/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemUpgradeBaseEnergy
extends ItemUpgradeBase {
    public ItemUpgradeBaseEnergy(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && this.hasEnergy(coin = (pedestal = (PedestalTileEntity)tileEntity).getCoinOnPedestal())) {
            float f = (float)this.getEnergyStored(coin) / (float)this.readMaxEnergyFromNBT(coin);
            intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
        }
        return intItem;
    }

    public void setMaxEnergy(ItemStack stack, int value) {
        this.writeMaxEnergyToNBT(stack, value);
    }

    public int getEnergyTransferRate(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 20000;
        switch (capacityOver) {
            case 0: {
                return 5000;
            }
            case 1: {
                return 10000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 50000;
            }
            case 4: {
                return 40000;
            }
            case 5: {
                return 60000;
            }
            case 6: {
                return 80000;
            }
            case 7: {
                return 100000;
            }
            case 8: {
                return 120000;
            }
            case 9: {
                return 140000;
            }
            case 10: {
                return 160000;
            }
        }
        return overEnchanted > this.maxStored ? this.maxStored : overEnchanted;
    }

    public static boolean isEnergyItem(ItemStack itemToCheck) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        return cap.isPresent();
    }

    public static boolean isEnergyItemInsert(ItemStack stack) {
        if (ItemUpgradeBaseEnergy.isEnergyItem(stack)) {
            return ItemUpgradeBaseEnergy.isEnergyItemInsert(stack, null);
        }
        return false;
    }

    public static boolean isEnergyItemInsert(ItemStack itemToCheck, @Nullable Direction facing) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            return cap.map(IEnergyStorage::canReceive).orElse(false);
        }
        return false;
    }

    public static boolean isEnergyItemExtract(ItemStack stack) {
        if (ItemUpgradeBaseEnergy.isEnergyItem(stack)) {
            return ItemUpgradeBaseEnergy.isEnergyItemExtract(stack, null);
        }
        return false;
    }

    public static boolean isEnergyItemExtract(ItemStack itemToCheck, @Nullable Direction facing) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            return cap.map(IEnergyStorage::canExtract).orElse(false);
        }
        return false;
    }

    public static int getMaxEnergyInStack(ItemStack itemToCheck, @Nullable Direction side) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            return cap.map(IEnergyStorage::getMaxEnergyStored).orElse(0);
        }
        return 0;
    }

    public static int getEnergyInStack(ItemStack itemToCheck) {
        return ItemUpgradeBaseEnergy.getEnergyInStack(itemToCheck, null);
    }

    public static int getEnergyInStack(ItemStack itemToCheck, @Nullable Direction side) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            return cap.map(IEnergyStorage::getEnergyStored).orElse(0);
        }
        return 0;
    }

    public static int insertEnergyIntoStack(ItemStack itemToCheck, int energy, boolean simulate) {
        return ItemUpgradeBaseEnergy.insertEnergyIntoStack(itemToCheck, null, energy, simulate);
    }

    public static int insertEnergyIntoStack(ItemStack itemToCheck, @Nullable Direction facing, int energy, boolean simulate) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            return cap.map(storage -> storage.receiveEnergy(energy, simulate)).orElse(0);
        }
        return 0;
    }

    public boolean itemHasMaxEnergy(ItemStack itemToCheck) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            IEnergyStorage handler = (IEnergyStorage)cap.orElse(null);
            int max = handler.getMaxEnergyStored();
            int current = handler.getEnergyStored();
            return current >= max;
        }
        return false;
    }

    public static int extractEnergyFromStack(ItemStack itemToCheck, int energy, boolean simulate) {
        return ItemUpgradeBaseEnergy.extractEnergyFromStack(itemToCheck, null, energy, simulate);
    }

    public static int extractEnergyFromStack(ItemStack itemToCheck, @Nullable Direction facing, int energy, boolean simulate) {
        LazyOptional cap = itemToCheck.getCapability(CapabilityEnergy.ENERGY);
        if (cap.isPresent()) {
            return cap.map(storage -> storage.extractEnergy(energy, simulate)).orElse(0);
        }
        return 0;
    }

    public static LazyOptional<IEnergyStorage> findEnergyHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap = neighbourTile.getCapability(CapabilityEnergy.ENERGY, side)).isPresent()) {
            return cap;
        }
        if (allowCart) {
            List list;
            if (AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos)) {
                LazyOptional cap2;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart);
                if (!list.isEmpty() && (cap2 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
                    return cap2;
                }
            } else {
                LazyOptional cap3;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof BoatEntity);
                if (!list.isEmpty() && (cap3 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
                    return cap3;
                }
            }
        }
        return LazyOptional.empty();
    }

    public void upgradeActionSendEnergy(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinMainPedestal = pedestal.getCoinOnPedestal();
        BlockPos posMainPedestal = pedestal.func_174877_v();
        int energyMainPedestal = this.getEnergyStored(coinMainPedestal);
        if (energyMainPedestal > 0 && pedestal.getNumberOfStoredLocations() > 0) {
            for (int i = 0; i < pedestal.getNumberOfStoredLocations(); ++i) {
                int energyLeftToSend;
                int transferRate;
                int energyStoredPedestal;
                ItemUpgradeBaseEnergy itemEB;
                int energyMaxStoredPedestal;
                int energySpaceInTargetPedestal;
                PedestalTileEntity tileStoredPedestal;
                ItemStack coinStoredPedestal;
                TileEntity storedPedestal;
                BlockPos posStoredPedestal = pedestal.getStoredPositionAt(i);
                if (world.func_175640_z(posStoredPedestal) || !world.func_175667_e(posStoredPedestal) || posStoredPedestal == posMainPedestal || !((storedPedestal = world.func_175625_s(posStoredPedestal)) instanceof PedestalTileEntity) || !((coinStoredPedestal = (tileStoredPedestal = (PedestalTileEntity)storedPedestal).getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBaseEnergy) || (energySpaceInTargetPedestal = (energyMaxStoredPedestal = (itemEB = (ItemUpgradeBaseEnergy)coinStoredPedestal.func_77973_b()).readMaxEnergyFromNBT(coinStoredPedestal)) - (energyStoredPedestal = itemEB.getEnergyStored(coinStoredPedestal))) <= 0) continue;
                int n = transferRate = this.getEnergyTransferRate(coinMainPedestal) <= energySpaceInTargetPedestal ? this.getEnergyTransferRate(coinMainPedestal) : energySpaceInTargetPedestal;
                if (itemEB.addEnergy(coinStoredPedestal, transferRate, true) && this.removeEnergy(coinMainPedestal, transferRate, true)) {
                    this.removeEnergy(coinMainPedestal, transferRate, false);
                    pedestal.update();
                    this.addEnergy(coinStoredPedestal, transferRate, false);
                    tileStoredPedestal.update();
                    continue;
                }
                int energyLeftInMain = this.getEnergyStored(coinMainPedestal) < this.getEnergyTransferRate(coinMainPedestal) ? this.getEnergyStored(coinMainPedestal) : this.getEnergyTransferRate(coinMainPedestal);
                energyStoredPedestal = itemEB.getEnergyStored(coinStoredPedestal);
                energySpaceInTargetPedestal = energyMaxStoredPedestal - energyStoredPedestal;
                transferRate = energyLeftInMain <= energySpaceInTargetPedestal ? energyLeftInMain : energySpaceInTargetPedestal;
                int n2 = energyLeftToSend = energyLeftInMain <= transferRate ? energyLeftInMain : transferRate;
                if (!itemEB.addEnergy(coinStoredPedestal, energyLeftToSend, true) || !this.removeEnergy(coinMainPedestal, energyLeftToSend, true)) continue;
                this.removeEnergy(coinMainPedestal, energyLeftToSend, false);
                pedestal.update();
                itemEB.addEnergy(coinStoredPedestal, energyLeftToSend, false);
                tileStoredPedestal.update();
            }
        }
    }

    public void sendEnergyToPedestal(PedestalTileEntity senderPedestal, PedestalTileEntity receiverPedestal) {
        int energyStoredPedestal;
        ItemUpgradeBaseEnergy itemEB;
        int energyMaxStoredPedestal;
        int energySpaceInTargetPedestal;
        PedestalTileEntity tileStoredPedestal;
        ItemStack coinStoredPedestal;
        BlockPos posStoredPedestal;
        World world = senderPedestal.func_145831_w();
        ItemStack coinMainPedestal = senderPedestal.getCoinOnPedestal();
        BlockPos posMainPedestal = senderPedestal.func_174877_v();
        int energyMainPedestal = this.getEnergyStored(coinMainPedestal);
        if (energyMainPedestal > 0 && !world.func_175640_z(posStoredPedestal = receiverPedestal.func_174877_v()) && world.func_175667_e(posStoredPedestal) && posStoredPedestal != posMainPedestal && (coinStoredPedestal = (tileStoredPedestal = receiverPedestal).getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBaseEnergy && (energySpaceInTargetPedestal = (energyMaxStoredPedestal = (itemEB = (ItemUpgradeBaseEnergy)coinStoredPedestal.func_77973_b()).readMaxEnergyFromNBT(coinStoredPedestal)) - (energyStoredPedestal = itemEB.getEnergyStored(coinStoredPedestal))) > 0) {
            int transferRate;
            int n = transferRate = this.getEnergyTransferRate(coinMainPedestal) <= energySpaceInTargetPedestal ? this.getEnergyTransferRate(coinMainPedestal) : energySpaceInTargetPedestal;
            if (itemEB.addEnergy(coinStoredPedestal, transferRate, true) && this.removeEnergy(coinMainPedestal, transferRate, true)) {
                this.removeEnergy(coinMainPedestal, transferRate, false);
                senderPedestal.update();
                this.addEnergy(coinStoredPedestal, transferRate, false);
                tileStoredPedestal.update();
            } else {
                int energyLeftToSend;
                int energyLeftInMain = this.getEnergyStored(coinMainPedestal) < this.getEnergyTransferRate(coinMainPedestal) ? this.getEnergyStored(coinMainPedestal) : this.getEnergyTransferRate(coinMainPedestal);
                energyStoredPedestal = itemEB.getEnergyStored(coinStoredPedestal);
                energySpaceInTargetPedestal = energyMaxStoredPedestal - energyStoredPedestal;
                transferRate = energyLeftInMain <= energySpaceInTargetPedestal ? energyLeftInMain : energySpaceInTargetPedestal;
                int n2 = energyLeftToSend = energyLeftInMain <= transferRate ? energyLeftInMain : transferRate;
                if (itemEB.addEnergy(coinStoredPedestal, energyLeftToSend, true) && this.removeEnergy(coinMainPedestal, energyLeftToSend, true)) {
                    this.removeEnergy(coinMainPedestal, energyLeftToSend, false);
                    senderPedestal.update();
                    itemEB.addEnergy(coinStoredPedestal, energyLeftToSend, false);
                    tileStoredPedestal.update();
                }
            }
        }
    }

    public int availableEnergySpaceInCoin(ItemStack coin) {
        int getMaxEnergy = this.readMaxEnergyFromNBT(coin);
        int getCurrentEnergy = this.getEnergyStored(coin);
        int difference = getMaxEnergy - getCurrentEnergy;
        if (this.hasEnergy(coin)) {
            return difference;
        }
        return getMaxEnergy;
    }

    public boolean addEnergy(ItemStack coin, int energyIn, boolean simulate) {
        int currentEnergy;
        int newEnergyValue;
        int getMaxEnergyValue = this.readMaxEnergyFromNBT(coin);
        if (getMaxEnergyValue >= (newEnergyValue = (currentEnergy = this.getEnergyStored(coin)) + energyIn)) {
            if (!simulate) {
                this.setEnergyStored(coin, newEnergyValue);
            }
            return true;
        }
        return false;
    }

    public int fillEnergy(ItemStack coin, int energyIn, boolean simulate) {
        int currentEnergy;
        int returner = 0;
        int getMaxEnergyValue = this.readMaxEnergyFromNBT(coin);
        int getSpace = getMaxEnergyValue - (currentEnergy = this.getEnergyStored(coin));
        int newEnergyValue = Math.min(getSpace, energyIn);
        if (newEnergyValue > 0) {
            if (!simulate) {
                this.addEnergy(coin, newEnergyValue, simulate);
            }
            returner = newEnergyValue;
        }
        return returner;
    }

    public boolean removeEnergy(ItemStack coin, int energyOut, boolean simulate) {
        int newEnergyValue;
        int getMaxEnergyValue = this.readMaxEnergyFromNBT(coin);
        int currentEnergy = this.getEnergyStored(coin);
        int energyDiff = currentEnergy - energyOut;
        int n = newEnergyValue = energyDiff > 0 ? energyDiff : 0;
        if (energyDiff >= 0) {
            if (!simulate) {
                this.setEnergyStored(coin, newEnergyValue);
            }
            return true;
        }
        return false;
    }

    public void setEnergyStored(ItemStack stack, int energy) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("energy", energy);
        stack.func_77982_d(compound);
    }

    public boolean hasEnergy(ItemStack stack) {
        return this.getEnergyStored(stack) > 0;
    }

    public int getEnergyStored(ItemStack stack) {
        int storedEnergy = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            storedEnergy = getCompound.func_74762_e("energy");
        }
        return storedEnergy;
    }

    public boolean hasMaxEnergySet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxenergy")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxEnergyToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxenergy", value);
        stack.func_77982_d(compound);
    }

    public int readMaxEnergyFromNBT(ItemStack stack) {
        int maxenergy = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxenergy = getCompound.func_74762_e("maxenergy");
        }
        return maxenergy;
    }

    public int getEnergyBuffer(ItemStack stack) {
        int capacityOver = this.getCapacityModifierOverEnchanted(stack);
        int overEnchanted = capacityOver * 20000;
        switch (capacityOver) {
            case 0: {
                return 5000;
            }
            case 1: {
                return 10000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 50000;
            }
            case 4: {
                return 40000;
            }
            case 5: {
                return 60000;
            }
            case 6: {
                return 80000;
            }
            case 7: {
                return 100000;
            }
            case 8: {
                return 120000;
            }
            case 9: {
                return 140000;
            }
            case 10: {
                return 160000;
            }
        }
        return overEnchanted > this.maxStored ? this.maxStored : overEnchanted;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && this.hasEnergy(pedestal.getCoinOnPedestal())) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, 1.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".chat_rfstored");
        xpstored.func_240702_b_("" + this.getEnergyStored(stack) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)xpstored, Util.field_240973_b_);
        TranslationTextComponent energyRate = new TranslationTextComponent(this.func_77658_a() + ".chat_rfrate");
        energyRate.func_240702_b_("" + this.getEnergyTransferRate(stack) + "");
        energyRate.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)energyRate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent xpstored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rfstored");
        xpstored.func_240702_b_("" + this.getEnergyStored(stack) + "");
        xpstored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)xpstored);
        TranslationTextComponent xpcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rfcapacity");
        xpcapacity.func_240702_b_("" + this.getEnergyBuffer(stack) + "");
        xpcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)xpcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getEnergyTransferRate(stack) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }
}

