/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.google.common.collect.Maps;
import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.api.upgrade.IUpgradeBase;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.enchants.EnchantmentRegistry;
import com.mowmaster.pedestals.item.ItemCraftingPlaceholder;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeCrafter;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import com.mowmaster.pedestals.util.PedestalFakePlayer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemUpgradeBase
extends Item
implements IUpgradeBase {
    public int maxStored = 2000000000;
    public int maxLVLStored = 20000;

    public ItemUpgradeBase(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    public boolean isPiglinCurrency(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemUpgradeBase;
    }

    @Override
    public boolean customIsValid(PedestalTileEntity pedestal, int slot, @Nonnull ItemStack stack) {
        return slot == 0;
    }

    @Override
    public ItemStack customExtractItem(PedestalTileEntity pedestal, int amountOut, boolean simulate) {
        return new ItemStack((IItemProvider)Items.field_221747_dJ);
    }

    @Override
    public ItemStack customInsertItem(PedestalTileEntity pedestal, ItemStack stackIn, boolean simulate) {
        return new ItemStack((IItemProvider)Items.field_221747_dJ);
    }

    @Override
    public ItemStack customStackInSlot(PedestalTileEntity pedestal, ItemStack stackFromHandler) {
        return new ItemStack((IItemProvider)Items.field_221747_dJ);
    }

    @Override
    public int customSlotLimit(PedestalTileEntity pedestal) {
        return -1;
    }

    @Override
    public boolean canAcceptItem(World world, BlockPos posPedestal, ItemStack itemStackIn) {
        return true;
    }

    @Override
    public int canAcceptCount(World world, BlockPos posPedestal, ItemStack inPedestal, ItemStack itemStackIncoming) {
        TileEntity tile = world.func_175625_s(posPedestal);
        if (tile instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tile;
            return Math.min(pedestal.getSlotSizeLimit(), itemStackIncoming.func_77976_d());
        }
        return 0;
    }

    public static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    public static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    public int[] getSlotsForSide(World world, BlockPos posOfPedestal, IInventory inventory) {
        int[] slots = new int[]{};
        if (inventory instanceof ISidedInventory) {
            slots = ((ISidedInventory)inventory).func_180463_a(this.getPedestalFacing(world, posOfPedestal));
        }
        return slots;
    }

    public boolean isInventoryEmpty(LazyOptional<IItemHandler> cap) {
        IItemHandler handler;
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            ItemStack itemFromInv = ItemStack.field_190927_a;
            itemFromInv = IntStream.range(0, range).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(itemStack -> !itemStack.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
            if (!itemFromInv.func_190926_b()) {
                return false;
            }
        }
        return true;
    }

    public ItemStack getStackInPedestal(World world, BlockPos posOfPedestal) {
        ItemStack stackInPedestal = ItemStack.field_190927_a;
        TileEntity pedestalInventory = world.func_175625_s(posOfPedestal);
        if (pedestalInventory instanceof PedestalTileEntity) {
            stackInPedestal = ((PedestalTileEntity)pedestalInventory).getItemInPedestal();
        }
        return stackInPedestal;
    }

    public void removeFromPedestal(World world, BlockPos posOfPedestal, int count) {
        ItemStack stackInPedestal = ItemStack.field_190927_a;
        TileEntity pedestalInventory = world.func_175625_s(posOfPedestal);
        if (pedestalInventory instanceof PedestalTileEntity) {
            ((PedestalTileEntity)pedestalInventory).removeItem(count);
        }
    }

    public int canAddToPedestal(World world, BlockPos posOfPedestal, ItemStack itemStackToAdd) {
        ItemStack stackInPedestal = ItemStack.field_190927_a;
        int returner = 0;
        TileEntity pedestalInventory = world.func_175625_s(posOfPedestal);
        if (pedestalInventory instanceof PedestalTileEntity) {
            returner = ((PedestalTileEntity)pedestalInventory).canAcceptItems(world, posOfPedestal, itemStackToAdd);
        }
        return returner;
    }

    public void addToPedestal(World world, BlockPos posOfPedestal, ItemStack itemStackToAdd) {
        ItemStack stackInPedestal = ItemStack.field_190927_a;
        TileEntity pedestalInventory = world.func_175625_s(posOfPedestal);
        if (pedestalInventory instanceof PedestalTileEntity) {
            ((PedestalTileEntity)pedestalInventory).addItem(itemStackToAdd);
        }
    }

    public void addToPedestalOverride(World world, BlockPos posOfPedestal, ItemStack itemStackToAdd) {
        ItemStack stackInPedestal = ItemStack.field_190927_a;
        TileEntity pedestalInventory = world.func_175625_s(posOfPedestal);
        if (pedestalInventory instanceof PedestalTileEntity) {
            ((PedestalTileEntity)pedestalInventory).addItemOverride(itemStackToAdd);
        }
    }

    public int intSpaceLeftInStack(ItemStack stack) {
        int value = 0;
        if (stack.equals(ItemStack.field_190927_a)) {
            value = 64;
        } else {
            int maxSize = stack.func_77976_d();
            int currentSize = stack.func_190916_E();
            value = maxSize - currentSize;
        }
        return value;
    }

    public boolean doItemsMatch(ItemStack stackPedestal, ItemStack itemStackIn) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    public boolean doItemsMatchWithEmpty(ItemStack stackPedestal, ItemStack itemStackIn) {
        if (stackPedestal.func_190926_b() && itemStackIn.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    @Override
    public boolean canSendItem(PedestalTileEntity tile) {
        return true;
    }

    public int getStorageBuffer(ItemStack coin) {
        int capacityOver = this.getCapacityModifierOverEnchanted(coin);
        int storageBuffer = (int)(Math.pow(4.0, capacityOver >= 33 ? 33.0 : (double)(capacityOver + 1)) * 1728.0);
        return storageBuffer >= Integer.MAX_VALUE ? Integer.MAX_VALUE : storageBuffer;
    }

    public int getFuelBuffer(ItemStack coin) {
        int getMaxFuelValue = 2000000000;
        return getMaxFuelValue;
    }

    public int getMaxFuelDeviderBasedOnFuelStored(int currentFuelStored) {
        int returner;
        for (returner = 10; currentFuelStored > returner; returner *= 10) {
            if (currentFuelStored < 2000000000) continue;
            returner = Integer.MAX_VALUE;
            break;
        }
        return returner;
    }

    public static LazyOptional<IItemHandler> findItemHandlerPedestal(PedestalTileEntity pedestal) {
        LazyOptional cap;
        BlockPos pos;
        World world = pedestal.func_145831_w();
        TileEntity neighbourTile = world.func_175625_s(pos = pedestal.func_174877_v());
        if (neighbourTile != null && (cap = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
            return cap;
        }
        if (allowCart) {
            List list;
            if (AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos)) {
                LazyOptional cap2;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart);
                if (!list.isEmpty() && (cap2 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                    return cap2;
                }
            } else {
                LazyOptional cap3;
                list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof BoatEntity);
                if (!list.isEmpty() && (cap3 = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                    return cap3;
                }
            }
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPosAdvanced(World world, BlockPos pos, Direction side, boolean allowEntity) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
            return cap2;
        }
        if (allowEntity && !(list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof Entity)).isEmpty() && (cap = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public int getNextSlotWithItemsCap(LazyOptional<IItemHandler> cap, ItemStack stackInPedestal) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || itemHandler.extractItem(i, 1, true).equals(ItemStack.field_190927_a)) continue;
                    if (stackInPedestal.func_190926_b()) {
                        slot.set(i);
                        break;
                    }
                    if (!this.doItemsMatch(stackInPedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public int getNextSlotWithItemsCapFiltered(PedestalTileEntity pedestal, LazyOptional<IItemHandler> cap, ItemStack stackInPedestal) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || itemHandler.extractItem(i, 1, true).equals(ItemStack.field_190927_a) || !this.passesItemFilter(pedestal, stackInSlot)) continue;
                    if (stackInPedestal.func_190926_b()) {
                        slot.set(i);
                        break;
                    }
                    if (!this.doItemsMatch(stackInPedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public boolean passesItemFilter(PedestalTileEntity pedestal, ItemStack stackIn) {
        Item filterInPedestal;
        boolean returner = true;
        if (pedestal.hasFilter() && (filterInPedestal = pedestal.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            returner = ((IFilterBase)filterInPedestal).canAcceptItem(pedestal, stackIn);
        }
        return returner;
    }

    public int hasEnoughInInv(LazyOptional<IItemHandler> cap, ItemStack stackToFind, int stopAfter) {
        int counter = 0;
        if (cap.isPresent()) {
            ItemStack stackInSlot;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            int range = handler.getSlots();
            for (int i = 0; i < range && ((stackInSlot = handler.getStackInSlot(i)).func_190926_b() || !this.doItemsMatch(stackInSlot, stackToFind) || (counter += stackInSlot.func_190916_E()) < stopAfter); ++i) {
            }
        }
        return counter;
    }

    public int getSlotWithMatchingStack(LazyOptional<IItemHandler> cap, ItemStack stackToFind) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || !stackInSlot.func_77969_a(stackToFind)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public int getSlotWithMatchingStackExact(LazyOptional<IItemHandler> cap, ItemStack stackToFind) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToFind)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public int getSlotWithMatchingStackExactFiltered(PedestalTileEntity pedestal, LazyOptional<IItemHandler> cap, ItemStack stackToFind) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToFind) || !this.passesItemFilter(pedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public int getPlayerSlotWithMatchingStackExact(PlayerInventory inventory, ItemStack stackToFind) {
        AtomicInteger slot = new AtomicInteger(-1);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToFind)) continue;
            slot.set(i);
            break;
        }
        return slot.get();
    }

    public int getPlayerSlotWithMatchingStackExactNotFull(PlayerInventory inventory, ItemStack stackToFind) {
        AtomicInteger slot = new AtomicInteger(-1);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToFind) || stackInSlot.func_190916_E() >= stackInSlot.func_77976_d()) continue;
            slot.set(i);
            break;
        }
        return slot.get();
    }

    public int getEnderChestSlotWithMatchingStackExact(EnderChestInventory inventory, ItemStack stackToFind) {
        AtomicInteger slot = new AtomicInteger(-1);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToFind)) continue;
            slot.set(i);
            break;
        }
        return slot.get();
    }

    public int getNextSlotWithItems(TileEntity invBeingChecked, Direction sideSlot, ItemStack stackInPedestal) {
        int slot = -1;
        if (invBeingChecked.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideSlot).isPresent()) {
            IItemHandler handler = (IItemHandler)invBeingChecked.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideSlot).orElse(null);
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.func_190926_b() || handler.extractItem(i, 1, true).equals(ItemStack.field_190927_a)) continue;
                if (stackInPedestal.func_190926_b()) {
                    slot = i;
                    break;
                }
                if (!this.doItemsMatch(stackInPedestal, stackInSlot)) continue;
                slot = i;
                break;
            }
        }
        return slot;
    }

    public int getNextIndexWithItems(List<ItemStack> stackList) {
        int range = stackList.size();
        for (int i = 0; i < range; ++i) {
            ItemStack stackInSlot = stackList.get(i);
            if (stackInSlot.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public boolean hasEnchant(ItemStack stack) {
        return stack.func_77948_v();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.func_77973_b() instanceof IUpgradeBase && enchantment.getRegistryName().func_110624_b().equals("pedestals")) {
            return !EnchantmentRegistry.COINUPGRADE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
        }
        return false;
    }

    public int func_77619_b() {
        return 10;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return stack.func_190916_E() == 1 ? super.isBookEnchantable(stack, book) : false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canAcceptOpSpeed() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return false;
    }

    @Override
    public boolean canAcceptMagnet() {
        return false;
    }

    @Override
    public boolean canAcceptRange() {
        return false;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return false;
    }

    public boolean hasMagnetEnchant(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MAGNET, (ItemStack)stack) >= 1;
    }

    public int intOperationalSpeedModifier(ItemStack stack) {
        int rate = 0;
        if (this.hasEnchant(stack)) {
            rate = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.OPERATIONSPEED, (ItemStack)stack) > 5 ? 5 : EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.OPERATIONSPEED, (ItemStack)stack);
        }
        return rate;
    }

    public int intOperationalSpeedOver(ItemStack stack) {
        int rate = 0;
        if (this.hasEnchant(stack)) {
            rate = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.OPERATIONSPEED, (ItemStack)stack);
        }
        return rate;
    }

    public int intOperationalSpeedModifierOverride(ItemStack stack) {
        int rate = 0;
        if (this.hasEnchant(stack)) {
            int speedOver = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.OPERATIONSPEED, (ItemStack)stack);
            return this.hasAdvancedInventoryTargeting(stack) ? speedOver : (speedOver > 5 ? 5 : speedOver);
        }
        return rate;
    }

    public double getOperationSpeedOverride(ItemStack stack) {
        int advancedAllowedSpeed = this.intOperationalSpeedModifierOverride(stack);
        double intOperationalSpeed = 20.0;
        switch (advancedAllowedSpeed) {
            case 0: {
                intOperationalSpeed = 20.0;
                break;
            }
            case 1: {
                intOperationalSpeed = 10.0;
                break;
            }
            case 2: {
                intOperationalSpeed = 5.0;
                break;
            }
            case 3: {
                intOperationalSpeed = 3.0;
                break;
            }
            case 4: {
                intOperationalSpeed = 2.0;
                break;
            }
            case 5: {
                intOperationalSpeed = 1.0;
                break;
            }
            default: {
                intOperationalSpeed = (double)advancedAllowedSpeed * 0.01 > 0.9 ? 0.1 : 1.0 - (double)advancedAllowedSpeed * 0.01;
            }
        }
        return intOperationalSpeed;
    }

    public int getOperationSpeed(ItemStack stack) {
        int intOperationalSpeed = 20;
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                intOperationalSpeed = 20;
                break;
            }
            case 1: {
                intOperationalSpeed = 10;
                break;
            }
            case 2: {
                intOperationalSpeed = 5;
                break;
            }
            case 3: {
                intOperationalSpeed = 3;
                break;
            }
            case 4: {
                intOperationalSpeed = 2;
                break;
            }
            case 5: {
                intOperationalSpeed = 1;
                break;
            }
            default: {
                intOperationalSpeed = 20;
            }
        }
        return intOperationalSpeed;
    }

    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent normal = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_0");
        TranslationTextComponent twox = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_1");
        TranslationTextComponent fourx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_2");
        TranslationTextComponent sixx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_3");
        TranslationTextComponent tenx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_4");
        TranslationTextComponent twentyx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_5");
        TranslationTextComponent overclockedx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_x");
        String overAmount = "" + (this.intOperationalSpeedModifier(stack) - 5) + "";
        String str = normal.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = normal.getString();
                break;
            }
            case 1: {
                str = twox.getString();
                break;
            }
            case 2: {
                str = fourx.getString();
                break;
            }
            case 3: {
                str = sixx.getString();
                break;
            }
            case 4: {
                str = tenx.getString();
                break;
            }
            case 5: {
                str = twentyx.getString();
                break;
            }
            default: {
                str = overclockedx.getString() + overAmount;
            }
        }
        return str;
    }

    public int getCapacityModifier(ItemStack stack) {
        int capacity = 0;
        if (this.hasEnchant(stack)) {
            capacity = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.CAPACITY, (ItemStack)stack) > 5 ? 5 : EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.CAPACITY, (ItemStack)stack);
        }
        return capacity;
    }

    public int getCapacityModifierOver(ItemStack stack) {
        int capacity = 0;
        if (this.hasEnchant(stack)) {
            capacity = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.CAPACITY, (ItemStack)stack);
        }
        return capacity;
    }

    public int getCapacityModifierOverEnchanted(ItemStack stack) {
        int capacity = 0;
        if (this.hasEnchant(stack)) {
            int capacityOver = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.CAPACITY, (ItemStack)stack);
            int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? capacityOver : (capacityOver > 5 ? 5 : capacityOver);
            return advancedAllowed;
        }
        return capacity;
    }

    public int getItemTransferRate(ItemStack stack) {
        int transferRate = 1;
        switch (this.getCapacityModifier(stack)) {
            case 0: {
                transferRate = 1;
                break;
            }
            case 1: {
                transferRate = 4;
                break;
            }
            case 2: {
                transferRate = 8;
                break;
            }
            case 3: {
                transferRate = 16;
                break;
            }
            case 4: {
                transferRate = 32;
                break;
            }
            case 5: {
                transferRate = 64;
                break;
            }
            default: {
                transferRate = 1;
            }
        }
        return transferRate;
    }

    public int getRangeModifier(ItemStack stack) {
        int range = 0;
        if (this.hasEnchant(stack)) {
            range = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.RANGE, (ItemStack)stack);
        }
        return range;
    }

    public int getRangeModifierLimited(ItemStack stack) {
        int range = 0;
        if (this.hasEnchant(stack)) {
            range = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.RANGE, (ItemStack)stack) > 5 ? 5 : EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.RANGE, (ItemStack)stack);
        }
        return range;
    }

    public int getRangeTiny(ItemStack stack) {
        return this.getRangeModifier(stack) * 2 + 3;
    }

    public int getRangeSmall(ItemStack stack) {
        int rangeOver = this.getRangeModifier(stack);
        int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? rangeOver : (rangeOver > 5 ? 5 : rangeOver);
        int height = 1;
        switch (advancedAllowed) {
            case 0: {
                height = 1;
                break;
            }
            case 1: {
                height = 2;
                break;
            }
            case 2: {
                height = 4;
                break;
            }
            case 3: {
                height = 8;
                break;
            }
            case 4: {
                height = 12;
                break;
            }
            case 5: {
                height = 16;
                break;
            }
            default: {
                height = advancedAllowed * 4 - 4;
            }
        }
        return height;
    }

    public int getRangeMedium(ItemStack stack) {
        int rangeOver = this.getRangeModifier(stack);
        int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? rangeOver : (rangeOver > 5 ? 5 : rangeOver);
        int height = 4;
        switch (advancedAllowed) {
            case 0: {
                height = 4;
                break;
            }
            case 1: {
                height = 8;
                break;
            }
            case 2: {
                height = 12;
                break;
            }
            case 3: {
                height = 16;
                break;
            }
            case 4: {
                height = 24;
                break;
            }
            case 5: {
                height = 32;
                break;
            }
            default: {
                height = advancedAllowed * 6 + 2;
            }
        }
        return height;
    }

    public int getRangeLarge(ItemStack stack) {
        int rangeOver = this.getRangeModifier(stack);
        int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? rangeOver : (rangeOver > 5 ? 5 : rangeOver);
        int height = 8;
        switch (advancedAllowed) {
            case 0: {
                height = 2;
                break;
            }
            case 1: {
                height = 4;
                break;
            }
            case 2: {
                height = 8;
                break;
            }
            case 3: {
                height = 16;
                break;
            }
            case 4: {
                height = 32;
                break;
            }
            case 5: {
                height = 64;
                break;
            }
            default: {
                height = advancedAllowed * 12;
            }
        }
        return height;
    }

    public int getRangeLargest(ItemStack stack) {
        int rangeOver = this.getRangeModifier(stack);
        int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? rangeOver : (rangeOver > 5 ? 5 : rangeOver);
        int height = 8;
        switch (advancedAllowed) {
            case 0: {
                height = 8;
                break;
            }
            case 1: {
                height = 16;
                break;
            }
            case 2: {
                height = 24;
                break;
            }
            case 3: {
                height = 32;
                break;
            }
            case 4: {
                height = 48;
                break;
            }
            case 5: {
                height = 64;
                break;
            }
            default: {
                height = advancedAllowed * 12;
            }
        }
        return height;
    }

    public int getRangeTree(ItemStack stack) {
        int rangeOver = this.getRangeModifier(stack);
        int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? rangeOver : (rangeOver > 5 ? 5 : rangeOver);
        return advancedAllowed * 6 + 6;
    }

    public int getAreaModifier(ItemStack stack) {
        int area = 0;
        if (this.hasEnchant(stack)) {
            int capacityOver = this.getAreaModifierUnRestricted(stack);
            int advancedAllowed = this.hasAdvancedInventoryTargeting(stack) ? capacityOver : (capacityOver > 5 ? 5 : capacityOver);
            return advancedAllowed;
        }
        return area;
    }

    public int getAreaModifierUnRestricted(ItemStack stack) {
        int area = 0;
        if (this.hasEnchant(stack)) {
            area = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.AREA, (ItemStack)stack);
        }
        return area;
    }

    public int getNumNonPedestalEnchants(Map<Enchantment, Integer> map) {
        int counter = 0;
        if (map.size() > 0) {
            for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
                Enchantment enchantment = entry.getKey();
                Integer integer = entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getAdvancedModifier(ItemStack stack) {
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        int advanced = 0;
        if (this.hasEnchant(stack) && !BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
            advanced = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.ADVANCED, (ItemStack)stack) > 1 ? 1 : EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.ADVANCED, (ItemStack)stack);
        }
        return advanced;
    }

    public boolean hasAdvancedInventoryTargeting(ItemStack stack) {
        return this.getAdvancedModifier(stack) >= 1;
    }

    public boolean hasAdvancedInventoryTargetingTwo(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.ADVANCED, (ItemStack)stack) >= 2;
    }

    @Override
    public void onPedestalNeighborChanged(PedestalTileEntity pedestal) {
    }

    @Override
    public void onPedestalBelowNeighborChanged(PedestalTileEntity pedestal, BlockState blockChanged, BlockPos blockChangedPos) {
    }

    public Block getBaseBlockBelow(World world, BlockPos pedestalPos) {
        Block block = world.func_180495_p(this.getPosOfBlockBelow(world, pedestalPos, 1)).func_177230_c();
        ITag BLOCK_EMERALD = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/emerald"));
        ITag BLOCK_DIAMOND = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/diamond"));
        ITag BLOCK_GOLD = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/gold"));
        ITag BLOCK_LAPIS = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/lapis"));
        ITag BLOCK_IRON = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/iron"));
        ITag BLOCK_COAL = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/coal"));
        ITag BLOCK_QUARTZ = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "storage_blocks/quartz"));
        if (block.equals(Blocks.field_235397_ng_)) {
            return Blocks.field_235397_ng_;
        }
        if (BLOCK_EMERALD.func_230235_a_((Object)block)) {
            return Blocks.field_150475_bE;
        }
        if (BLOCK_DIAMOND.func_230235_a_((Object)block)) {
            return Blocks.field_150484_ah;
        }
        if (BLOCK_GOLD.func_230235_a_((Object)block)) {
            return Blocks.field_150340_R;
        }
        if (BLOCK_LAPIS.func_230235_a_((Object)block)) {
            return Blocks.field_150368_y;
        }
        if (BLOCK_IRON.func_230235_a_((Object)block)) {
            return Blocks.field_150339_S;
        }
        if (BLOCK_COAL.func_230235_a_((Object)block)) {
            return Blocks.field_150402_ci;
        }
        if (BLOCK_QUARTZ.func_230235_a_((Object)block)) {
            return Blocks.field_150371_ca;
        }
        if (block.equals(Blocks.field_180399_cE)) {
            return Blocks.field_180399_cE;
        }
        return block;
    }

    public double[] getPedTopPos(PedestalTileEntity pedestal, double Yheight) {
        BlockPos pos = pedestal.func_174877_v();
        BlockState state = pedestal.func_195044_w();
        Direction enumfacing = Direction.UP;
        if (state.func_177230_c() instanceof PedestalBlock) {
            enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        switch (enumfacing) {
            case UP: {
                return new double[]{0.5, Yheight, 0.5};
            }
            case DOWN: {
                return new double[]{0.5, 1.0 - Yheight, 0.5};
            }
            case NORTH: {
                return new double[]{0.5, 0.5, 1.0 - Yheight};
            }
            case SOUTH: {
                return new double[]{0.5, 0.5, Yheight};
            }
            case EAST: {
                return new double[]{Yheight, 0.5, 0.5};
            }
            case WEST: {
                return new double[]{1.0 - Yheight, 0.5, 0.5};
            }
        }
        return new double[]{0.5, Yheight, 0.5};
    }

    public BlockPos getPosOfBlockBelow(World world, BlockPos posOfPedestal, int numBelow) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = state.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(0, -numBelow, 0);
            }
            case DOWN: {
                return blockBelow.func_177982_a(0, numBelow, 0);
            }
            case NORTH: {
                return blockBelow.func_177982_a(0, 0, numBelow);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(0, 0, -numBelow);
            }
            case EAST: {
                return blockBelow.func_177982_a(-numBelow, 0, 0);
            }
            case WEST: {
                return blockBelow.func_177982_a(numBelow, 0, 0);
            }
        }
        return blockBelow;
    }

    public BlockPos getNegRangePos(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(-intWidth, 0, -intWidth);
            }
            case DOWN: {
                return blockBelow.func_177982_a(-intWidth, -intHeight, -intWidth);
            }
            case NORTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, -intHeight);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, 0);
            }
            case EAST: {
                return blockBelow.func_177982_a(0, -intWidth, -intWidth);
            }
            case WEST: {
                return blockBelow.func_177982_a(-intHeight, -intWidth, -intWidth);
            }
        }
        return blockBelow;
    }

    public BlockPos getPosRangePos(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(intWidth, intHeight, intWidth);
            }
            case DOWN: {
                return blockBelow.func_177982_a(intWidth, 0, intWidth);
            }
            case NORTH: {
                return blockBelow.func_177982_a(intWidth, intWidth, 0);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(intWidth, intWidth, intHeight);
            }
            case EAST: {
                return blockBelow.func_177982_a(intHeight, intWidth, intWidth);
            }
            case WEST: {
                return blockBelow.func_177982_a(0, intWidth, intWidth);
            }
        }
        return blockBelow;
    }

    public BlockPos getPosOfNextBlock(int currentPosition, BlockPos negCorner, BlockPos posCorner) {
        int xRange = Math.abs(posCorner.func_177958_n() - negCorner.func_177958_n());
        int yRange = Math.abs(posCorner.func_177956_o() - negCorner.func_177956_o());
        int zRange = Math.abs(posCorner.func_177952_p() - negCorner.func_177952_p());
        int layerVolume = xRange * zRange;
        int addY = (int)Math.floor(currentPosition / layerVolume);
        int layerCurrentPosition = currentPosition - addY * layerVolume;
        int addZ = (int)Math.floor(layerCurrentPosition / xRange);
        int addX = layerCurrentPosition - addZ * xRange;
        return negCorner.func_177982_a(addX, addY, addZ);
    }

    public boolean resetCurrentPosInt(int currentPosition, BlockPos negCorner, BlockPos posCorner) {
        int xRange = Math.abs(posCorner.func_177958_n() - negCorner.func_177958_n());
        int yRange = Math.abs(posCorner.func_177956_o() - negCorner.func_177956_o());
        int zRange = Math.abs(posCorner.func_177952_p() - negCorner.func_177952_p());
        int layerVolume = xRange * zRange;
        int addY = (int)Math.floor(currentPosition / layerVolume);
        return addY >= yRange;
    }

    public boolean passesFilter(World world, BlockPos posPedestal, Block blockIn) {
        return false;
    }

    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockState blockToMineState = world.func_180495_p(blockToMinePos);
        Block blockToMine = blockToMineState.func_177230_c();
        ItemStack pickaxe = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151046_w, 1);
        ToolType tool = blockToMineState.getHarvestTool();
        FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
        if (fakePlayer != null) {
            boolean advanced;
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(pedestalPos.func_177958_n(), pedestalPos.func_177956_o(), pedestalPos.func_177952_p()))) {
                fakePlayer.func_70107_b((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p());
            }
            if (!this.doItemsMatch(fakePlayer.func_184614_ca(), pickaxe)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, pickaxe);
            }
            ITag ADVANCED = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/advanced"));
            ITag BLACKLIST = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/blacklist"));
            boolean bl = ADVANCED.func_230235_a_((Object)blockToMine) ? this.hasAdvancedInventoryTargeting(coinInPedestal) : (advanced = true);
            if (!blockToMine.isAir(blockToMineState, (IBlockReader)world, blockToMinePos) && !(blockToMine instanceof PedestalBlock) && this.passesFilter(world, pedestalPos, blockToMine) && !(blockToMine instanceof IFluidBlock) && !(blockToMine instanceof FlowingFluidBlock) && ForgeHooks.canHarvestBlock((BlockState)blockToMineState, (PlayerEntity)fakePlayer, (IBlockReader)world, (BlockPos)blockToMinePos) && blockToMineState.func_185887_b((IBlockReader)world, blockToMinePos) != -1.0f && !BLACKLIST.func_230235_a_((Object)blockToMine) && advanced) {
                return true;
            }
        }
        return false;
    }

    public boolean canMineBlockTwo(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        return false;
    }

    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        boolean advanced;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockState blockToMineState = world.func_180495_p(blockToMinePos);
        Block blockToMine = blockToMineState.func_177230_c();
        ItemStack pickaxe = pedestal.hasTool() ? pedestal.getToolOnPedestal() : new ItemStack((IItemProvider)Items.field_151046_w, 1);
        ToolType tool = blockToMineState.getHarvestTool();
        player.func_70107_b((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p());
        if (!this.doItemsMatch(player.func_184614_ca(), pickaxe)) {
            player.func_184201_a(EquipmentSlotType.MAINHAND, pickaxe);
        }
        ITag ADVANCED = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/advanced"));
        ITag BLACKLIST = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("pedestals", "quarry/blacklist"));
        boolean bl = ADVANCED.func_230235_a_((Object)blockToMine) ? this.hasAdvancedInventoryTargeting(coinInPedestal) : (advanced = true);
        return !blockToMine.isAir(blockToMineState, (IBlockReader)world, blockToMinePos) && !(blockToMine instanceof PedestalBlock) && this.passesFilter(world, pedestalPos, blockToMine) && !(blockToMine instanceof IFluidBlock) && !(blockToMine instanceof FlowingFluidBlock) && ForgeHooks.canHarvestBlock((BlockState)blockToMineState, (PlayerEntity)player, (IBlockReader)world, (BlockPos)blockToMinePos) && blockToMineState.func_185887_b((IBlockReader)world, blockToMinePos) != -1.0f && !BLACKLIST.func_230235_a_((Object)blockToMine) && advanced;
    }

    public ItemStack getToolDefaultEnchanted(ItemStack coinInPedestal, ItemStack tool) {
        if (EnchantmentHelper.func_82781_a((ItemStack)coinInPedestal).containsKey(Enchantments.field_185306_r)) {
            tool.func_77966_a(Enchantments.field_185306_r, 1);
        } else if (EnchantmentHelper.func_82781_a((ItemStack)coinInPedestal).containsKey(Enchantments.field_185308_t)) {
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)coinInPedestal);
            tool.func_77966_a(Enchantments.field_185308_t, lvl);
        }
        return tool;
    }

    public Direction getPedestalFacing(World world, BlockPos posOfPedestal) {
        BlockState state = world.func_180495_p(posOfPedestal);
        return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    public LivingEntity getTargetEntity(Block filterBlock, LivingEntity entityIn) {
        if (filterBlock.equals(Blocks.field_150475_bE)) {
            if (entityIn instanceof PlayerEntity) {
                return (PlayerEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150484_ah)) {
            if (entityIn instanceof MonsterEntity) {
                return (MonsterEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150340_R)) {
            if (entityIn instanceof AnimalEntity) {
                return (AnimalEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150368_y)) {
            if (entityIn instanceof FlyingEntity) {
                return (FlyingEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150339_S)) {
            if (entityIn instanceof CreatureEntity) {
                return (CreatureEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150402_ci)) {
            if (entityIn instanceof MobEntity) {
                return (MobEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150407_cf)) {
            if (entityIn.func_70631_g_()) {
                return entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_203216_jz)) {
            if (!entityIn.func_70631_g_()) {
                return entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_196812_go)) {
            if (entityIn instanceof VillagerEntity) {
                return (VillagerEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_196824_gy)) {
            if (entityIn instanceof AbstractRaiderEntity) {
                return (AbstractRaiderEntity)entityIn;
            }
        } else {
            return entityIn;
        }
        return null;
    }

    public Entity getTargetEntityAdvanced(Block filterBlock, Entity entityIn) {
        if (filterBlock.equals(Blocks.field_150475_bE)) {
            if (entityIn instanceof PlayerEntity) {
                return (PlayerEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150484_ah)) {
            if (entityIn instanceof MonsterEntity) {
                return (MonsterEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150340_R)) {
            if (entityIn instanceof AnimalEntity) {
                return (AnimalEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150368_y)) {
            if (entityIn instanceof FlyingEntity) {
                return (FlyingEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150339_S)) {
            if (entityIn instanceof CreatureEntity) {
                return (CreatureEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150402_ci)) {
            if (entityIn instanceof MobEntity) {
                return (MobEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150407_cf)) {
            if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70631_g_()) {
                return entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_203216_jz)) {
            if (entityIn instanceof LivingEntity && !((LivingEntity)entityIn).func_70631_g_()) {
                return entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_196812_go)) {
            if (entityIn instanceof VillagerEntity) {
                return (VillagerEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_196824_gy)) {
            if (entityIn instanceof AbstractRaiderEntity) {
                return (AbstractRaiderEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_150371_ca)) {
            if (entityIn instanceof ItemEntity) {
                return (ItemEntity)entityIn;
            }
        } else if (filterBlock.equals(Blocks.field_180399_cE)) {
            if (entityIn instanceof ExperienceOrbEntity) {
                return (ExperienceOrbEntity)entityIn;
            }
        } else {
            return entityIn;
        }
        return null;
    }

    public String getTargetEntity(Block filterBlock) {
        TranslationTextComponent EMERALD = new TranslationTextComponent("pedestals.target_entities.entity_emerald");
        TranslationTextComponent DIAMOND = new TranslationTextComponent("pedestals.target_entities.entity_diamond");
        TranslationTextComponent GOLD = new TranslationTextComponent("pedestals.target_entities.entity_gold");
        TranslationTextComponent LAPIS = new TranslationTextComponent("pedestals.target_entities.entity_lapis");
        TranslationTextComponent IRON = new TranslationTextComponent("pedestals.target_entities.entity_iron");
        TranslationTextComponent COAL = new TranslationTextComponent("pedestals.target_entities.entity_coal");
        TranslationTextComponent HAY = new TranslationTextComponent("pedestals.target_entities.entity_hay");
        TranslationTextComponent KELP = new TranslationTextComponent("pedestals.target_entities.entity_kelp");
        TranslationTextComponent GLASS_LIME = new TranslationTextComponent("pedestals.target_entities.entity_glass_lime");
        TranslationTextComponent GLASS_BLACK = new TranslationTextComponent("pedestals.target_entities.entity_glass_black");
        TranslationTextComponent ALL = new TranslationTextComponent("pedestals.target_entities.entity_all");
        if (filterBlock.equals(Blocks.field_150475_bE)) {
            return EMERALD.getString();
        }
        if (filterBlock.equals(Blocks.field_150484_ah)) {
            return DIAMOND.getString();
        }
        if (filterBlock.equals(Blocks.field_150340_R)) {
            return GOLD.getString();
        }
        if (filterBlock.equals(Blocks.field_150368_y)) {
            return LAPIS.getString();
        }
        if (filterBlock.equals(Blocks.field_150339_S)) {
            return IRON.getString();
        }
        if (filterBlock.equals(Blocks.field_150402_ci)) {
            return COAL.getString();
        }
        if (filterBlock.equals(Blocks.field_150407_cf)) {
            return HAY.getString();
        }
        if (filterBlock.equals(Blocks.field_203216_jz)) {
            return KELP.getString();
        }
        if (filterBlock.equals(Blocks.field_196812_go)) {
            return GLASS_LIME.getString();
        }
        if (filterBlock.equals(Blocks.field_196824_gy)) {
            return GLASS_BLACK.getString();
        }
        return ALL.getString();
    }

    public String getTargetEntityAdvanced(Block filterBlock) {
        TranslationTextComponent EMERALD = new TranslationTextComponent("pedestals.target_entities.entity_emerald");
        TranslationTextComponent DIAMOND = new TranslationTextComponent("pedestals.target_entities.entity_diamond");
        TranslationTextComponent GOLD = new TranslationTextComponent("pedestals.target_entities.entity_gold");
        TranslationTextComponent LAPIS = new TranslationTextComponent("pedestals.target_entities.entity_lapis");
        TranslationTextComponent IRON = new TranslationTextComponent("pedestals.target_entities.entity_iron");
        TranslationTextComponent COAL = new TranslationTextComponent("pedestals.target_entities.entity_coal");
        TranslationTextComponent ALL = new TranslationTextComponent("pedestals.target_entities.entity_all");
        TranslationTextComponent HAY = new TranslationTextComponent("pedestals.target_entities.entity_hay");
        TranslationTextComponent GLASS_LIME = new TranslationTextComponent("pedestals.target_entities.entity_glass_lime");
        TranslationTextComponent GLASS_BLACK = new TranslationTextComponent("pedestals.target_entities.entity_glass_black");
        TranslationTextComponent SLIME = new TranslationTextComponent("pedestals.target_entities.entity_slime");
        TranslationTextComponent QUARTZ = new TranslationTextComponent("pedestals.target_entities.entity_quartz");
        if (filterBlock.equals(Blocks.field_150475_bE)) {
            return EMERALD.getString();
        }
        if (filterBlock.equals(Blocks.field_150484_ah)) {
            return DIAMOND.getString();
        }
        if (filterBlock.equals(Blocks.field_150340_R)) {
            return GOLD.getString();
        }
        if (filterBlock.equals(Blocks.field_150368_y)) {
            return LAPIS.getString();
        }
        if (filterBlock.equals(Blocks.field_150339_S)) {
            return IRON.getString();
        }
        if (filterBlock.equals(Blocks.field_150402_ci)) {
            return COAL.getString();
        }
        if (filterBlock.equals(Blocks.field_180399_cE)) {
            return SLIME.getString();
        }
        if (filterBlock.equals(Blocks.field_150371_ca)) {
            return QUARTZ.getString();
        }
        if (filterBlock.equals(Blocks.field_150407_cf)) {
            return HAY.getString();
        }
        if (filterBlock.equals(Blocks.field_196812_go)) {
            return GLASS_LIME.getString();
        }
        if (filterBlock.equals(Blocks.field_196824_gy)) {
            return GLASS_BLACK.getString();
        }
        return ALL.getString();
    }

    public BlockPos getNegRangePosEntity(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(-intWidth, 0, -intWidth);
            }
            case DOWN: {
                return blockBelow.func_177982_a(-intWidth, -intHeight, -intWidth);
            }
            case NORTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, -intHeight);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, 0);
            }
            case EAST: {
                return blockBelow.func_177982_a(0, -intWidth, -intWidth);
            }
            case WEST: {
                return blockBelow.func_177982_a(-intHeight, -intWidth, -intWidth);
            }
        }
        return blockBelow;
    }

    public BlockPos getPosRangePosEntity(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(intWidth + 1, intHeight, intWidth + 1);
            }
            case DOWN: {
                return blockBelow.func_177982_a(intWidth + 1, 0, intWidth + 1);
            }
            case NORTH: {
                return blockBelow.func_177982_a(intWidth + 1, intWidth, 1);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(intWidth + 1, intWidth, intHeight + 1);
            }
            case EAST: {
                return blockBelow.func_177982_a(intHeight + 1, intWidth, intWidth + 1);
            }
            case WEST: {
                return blockBelow.func_177982_a(1, intWidth, intWidth + 1);
            }
        }
        return blockBelow;
    }

    public boolean canThisPedestalReceiveItemStack(PedestalTileEntity pedestal, World world, BlockPos posOfPedestal, ItemStack itemStackIncoming) {
        Item filterInPedestal;
        boolean filter = true;
        if (pedestal.canAcceptItems(world, posOfPedestal, itemStackIncoming) > 0 && pedestal.hasFilter() && (filterInPedestal = pedestal.getFilterInPedestal().func_77973_b()) instanceof IFilterBase) {
            filter = ((IFilterBase)filterInPedestal).canAcceptItem(pedestal, itemStackIncoming);
        }
        return filter;
    }

    public void upgradeActionMagnet(PedestalTileEntity pedestal, World world, List<ItemEntity> itemList, ItemStack itemInPedestal, BlockPos posOfPedestal) {
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (itemList.size() > 0) {
            for (ItemEntity getItemFromList : itemList) {
                ItemStack copyStack = getItemFromList.func_92059_d().func_77946_l();
                int maxSize = copyStack.func_77976_d();
                boolean stacksMatch = this.doItemsMatch(itemInPedestal, copyStack);
                if (!itemInPedestal.func_190926_b() && !stacksMatch || !this.canThisPedestalReceiveItemStack(pedestal, world, posOfPedestal, copyStack)) continue;
                int spaceInPed = itemInPedestal.func_77976_d() - itemInPedestal.func_190916_E();
                if (stacksMatch) {
                    if (spaceInPed > 0) {
                        int itemInCount = getItemFromList.func_92059_d().func_190916_E();
                        int countToAdd = itemInCount <= spaceInPed ? itemInCount : spaceInPed;
                        getItemFromList.func_92059_d().func_190920_e(itemInCount - countToAdd);
                        copyStack.func_190920_e(countToAdd);
                        pedestal.addItem(copyStack);
                        if (!pedestal.hasMuffler()) {
                            world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        }
                    } else if (!this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) {
                        break;
                    }
                } else if (copyStack.func_190916_E() <= maxSize) {
                    getItemFromList.func_92058_a(ItemStack.field_190927_a);
                    getItemFromList.func_70106_y();
                    pedestal.addItem(copyStack);
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                } else {
                    int count = getItemFromList.func_92059_d().func_190916_E();
                    getItemFromList.func_92059_d().func_190920_e(count - maxSize);
                    copyStack.func_190920_e(maxSize);
                    pedestal.addItem(copyStack);
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                }
                if (this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) continue;
                break;
            }
        }
    }

    public ItemStack getFilterReturnStack(List<ItemStack> stack, ItemStack incoming) {
        int range = stack.size();
        ItemStack itemFromInv = ItemStack.field_190927_a;
        itemFromInv = IntStream.range(0, range).mapToObj(stack::get).filter(itemStack -> itemStack.func_77973_b().equals(incoming.func_77973_b())).findFirst().orElse(ItemStack.field_190927_a);
        return itemFromInv;
    }

    @Override
    public void removePlayerFromCoin(ItemStack stack) {
        if (this.hasPlayerSet(stack)) {
            CompoundNBT compound = new CompoundNBT();
            if (stack.func_77942_o()) {
                compound = stack.func_77978_p();
                if (compound.func_74764_b("player")) {
                    compound.func_82580_o("player");
                }
                if (compound.func_74764_b("playername")) {
                    compound.func_82580_o("playername");
                }
                stack.func_77982_d(compound);
            }
        }
    }

    public UUID getPlayerFromCoin(ItemStack stack) {
        UUID playerID;
        if (this.hasPlayerSet(stack) && (playerID = this.readUUIDFromNBT(stack)) != null) {
            return playerID;
        }
        return Util.field_240973_b_;
    }

    public WeakReference<FakePlayer> fakePedestalPlayer(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        return new WeakReference<FakePlayer>(new PedestalFakePlayer(sworld, this.getPlayerFromCoin(pedestal.getCoinOnPedestal()), this.getPlayerNameFromCoin(pedestal.getCoinOnPedestal()), pedestal));
    }

    public WeakReference<FakePlayer> fakePedestalPlayer(PedestalTileEntity pedestal, ItemStack itemInHand) {
        World world = pedestal.func_145831_w();
        ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        return new WeakReference<FakePlayer>(new PedestalFakePlayer(sworld, this.getPlayerFromCoin(pedestal.getCoinOnPedestal()), this.getPlayerNameFromCoin(pedestal.getCoinOnPedestal()), pedestal.func_174877_v(), itemInHand));
    }

    @Override
    public void setPlayerOnCoin(ItemStack stack, PlayerEntity player) {
        this.writeUUIDToNBT(stack, player.func_110124_au());
        this.writeNameToNBT(stack, player.func_145748_c_().getString());
    }

    public boolean hasPlayerSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("player") && this.readUUIDFromNBT(stack) != null) {
            returner = true;
        }
        return returner;
    }

    public void writeUUIDToNBT(ItemStack stack, UUID uuidIn) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_186854_a("player", uuidIn);
        stack.func_77982_d(compound);
    }

    public UUID readUUIDFromNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            return getCompound.func_186857_a("player");
        }
        return null;
    }

    public String getPlayerNameFromCoin(ItemStack stack) {
        if (this.hasPlayerNameSet(stack)) {
            return this.readNameFromNBT(stack);
        }
        return null;
    }

    public boolean hasPlayerNameSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("playername") && this.readNameFromNBT(stack) != null) {
            returner = true;
        }
        return returner;
    }

    public void writeNameToNBT(ItemStack stack, String name) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74778_a("playername", name);
        stack.func_77982_d(compound);
    }

    public String readNameFromNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            return getCompound.func_74779_i("playername");
        }
        return null;
    }

    @Override
    public void removeWorkQueueFromCoin(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("workqueueposx")) {
            compound.func_82580_o("workqueueposx");
            compound.func_82580_o("workqueueposy");
            compound.func_82580_o("workqueueposz");
            stack.func_77982_d(compound);
        }
    }

    public int workQueueSize(ItemStack coin) {
        CompoundNBT getCompound;
        int workQueueSize = 0;
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("workqueueposx")) {
            int[] xval = getCompound.func_74759_k("workqueueposx");
            return xval.length;
        }
        return workQueueSize;
    }

    public void buildWorkQueue(PedestalTileEntity pedestal, int width, int height) {
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        ItemStack pickaxe = pedestal.getToolOnPedestal();
        BlockState pedestalState = world.func_180495_p(pedestalPos);
        Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, width, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? height - 1 : height);
        BlockPos posNums = this.getPosRangePosEntity(world, pedestalPos, width, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? height - 1 : height);
        FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get();
        if (fakePlayer != null) {
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(pedestalPos.func_177958_n(), pedestalPos.func_177956_o(), pedestalPos.func_177952_p()))) {
                fakePlayer.func_70107_b((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p());
            }
            if (!this.doItemsMatch(fakePlayer.func_184614_ca(), pickaxe)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, pickaxe);
            }
            ArrayList<BlockPos> workQueue = new ArrayList<BlockPos>();
            int i = 0;
            while (!this.resetCurrentPosInt(i, enumfacing == Direction.DOWN ? negNums.func_177982_a(0, 1, 0) : negNums, enumfacing != Direction.UP ? posNums.func_177982_a(0, 1, 0) : posNums)) {
                BlockPos targetPos = this.getPosOfNextBlock(i, enumfacing == Direction.DOWN ? negNums.func_177982_a(0, 1, 0) : negNums, enumfacing != Direction.UP ? posNums.func_177982_a(0, 1, 0) : posNums);
                BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                if (this.canMineBlock(pedestal, blockToMinePos, (PlayerEntity)fakePlayer)) {
                    workQueue.add(blockToMinePos);
                }
                ++i;
            }
            this.writeWorkQueueToNBT(coin, workQueue);
        }
    }

    public void writeWorkQueueToNBT(ItemStack coin, List<BlockPos> listIn) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        ArrayList<Integer> xval = new ArrayList<Integer>();
        ArrayList<Integer> yval = new ArrayList<Integer>();
        ArrayList<Integer> zval = new ArrayList<Integer>();
        for (int i = 0; i < listIn.size(); ++i) {
            xval.add(i, listIn.get(i).func_177958_n());
            yval.add(i, listIn.get(i).func_177956_o());
            zval.add(i, listIn.get(i).func_177952_p());
        }
        compound.func_197646_b("workqueueposx", xval);
        compound.func_197646_b("workqueueposy", yval);
        compound.func_197646_b("workqueueposz", zval);
        coin.func_77982_d(compound);
    }

    public List<BlockPos> readWorkQueueFromNBT(ItemStack coin) {
        ArrayList<BlockPos> workQueue = new ArrayList<BlockPos>();
        if (this.workQueueSize(coin) >= 0 && coin.func_77942_o()) {
            CompoundNBT getCompound = coin.func_77978_p();
            int[] xval = getCompound.func_74759_k("workqueueposx");
            int[] yval = getCompound.func_74759_k("workqueueposy");
            int[] zval = getCompound.func_74759_k("workqueueposz");
            for (int i = 0; i < xval.length; ++i) {
                workQueue.add(new BlockPos(xval[i], yval[i], zval[i]));
            }
        }
        return workQueue;
    }

    @Override
    public void removeWorkQueueTwoFromCoin(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("workqueuetwoposx")) {
            compound.func_82580_o("workqueuetwoposx");
            compound.func_82580_o("workqueuetwoposy");
            compound.func_82580_o("workqueuetwoposz");
            stack.func_77982_d(compound);
        }
    }

    public int workQueueTwoSize(ItemStack coin) {
        CompoundNBT getCompound;
        int workQueueTwoSize = 0;
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("workqueuetwoposx")) {
            int[] xval = getCompound.func_74759_k("workqueuetwoposx");
            return xval.length;
        }
        return workQueueTwoSize;
    }

    public void buildWorkQueueTwo(PedestalTileEntity pedestal, int width, int height) {
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        BlockState pedestalState = world.func_180495_p(pedestalPos);
        Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, width, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? height - 1 : height);
        BlockPos posNums = this.getPosRangePosEntity(world, pedestalPos, width, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? height - 1 : height);
        ArrayList<BlockPos> workQueueTwo = new ArrayList<BlockPos>();
        int i = 0;
        while (!this.resetCurrentPosInt(i, enumfacing == Direction.DOWN ? negNums.func_177982_a(0, 1, 0) : negNums, enumfacing != Direction.UP ? posNums.func_177982_a(0, 1, 0) : posNums)) {
            BlockPos targetPos = this.getPosOfNextBlock(i, enumfacing == Direction.DOWN ? negNums.func_177982_a(0, 1, 0) : negNums, enumfacing != Direction.UP ? posNums.func_177982_a(0, 1, 0) : posNums);
            BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            if (this.canMineBlockTwo(pedestal, blockToMinePos)) {
                workQueueTwo.add(blockToMinePos);
            }
            ++i;
        }
        this.writeWorkQueueTwoToNBT(coin, workQueueTwo);
    }

    public void writeWorkQueueTwoToNBT(ItemStack coin, List<BlockPos> listIn) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        ArrayList<Integer> xval = new ArrayList<Integer>();
        ArrayList<Integer> yval = new ArrayList<Integer>();
        ArrayList<Integer> zval = new ArrayList<Integer>();
        for (int i = 0; i < listIn.size(); ++i) {
            xval.add(i, listIn.get(i).func_177958_n());
            yval.add(i, listIn.get(i).func_177956_o());
            zval.add(i, listIn.get(i).func_177952_p());
        }
        compound.func_197646_b("workqueuetwoposx", xval);
        compound.func_197646_b("workqueuetwoposy", yval);
        compound.func_197646_b("workqueuetwoposz", zval);
        coin.func_77982_d(compound);
    }

    public List<BlockPos> readWorkQueueTwoFromNBT(ItemStack coin) {
        ArrayList<BlockPos> workQueueTwo = new ArrayList<BlockPos>();
        if (this.workQueueTwoSize(coin) >= 0 && coin.func_77942_o()) {
            CompoundNBT getCompound = coin.func_77978_p();
            int[] xval = getCompound.func_74759_k("workqueuetwoposx");
            int[] yval = getCompound.func_74759_k("workqueuetwoposy");
            int[] zval = getCompound.func_74759_k("workqueuetwoposz");
            for (int i = 0; i < xval.length; ++i) {
                workQueueTwo.add(new BlockPos(xval[i], yval[i], zval[i]));
            }
        }
        return workQueueTwo;
    }

    @Override
    public void removeFilterQueueHandler(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("filterqueue")) {
            compound.func_82580_o("filterqueue");
            stack.func_77982_d(compound);
        }
    }

    public int filterQueueSize(ItemStack coin) {
        CompoundNBT getCompound;
        int filterQueueSize = 0;
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("filterqueue")) {
            getCompound.func_74781_a("filterqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(getCompound);
            return handler.getSlots();
        }
        return filterQueueSize;
    }

    public List<ItemStack> buildFilterQueue(PedestalTileEntity pedestal) {
        IItemHandler handler;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        BlockState pedestalState = world.func_180495_p(pedestalPos);
        Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos posInventory = this.getPosOfBlockBelow(world, pedestalPos, 1);
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        LazyOptional<IItemHandler> cap = ItemUpgradeBase.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, pedestalPos), true);
        if (this.hasAdvancedInventoryTargeting(coin)) {
            cap = ItemUpgradeBase.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, pedestalPos), true);
        }
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.func_190926_b()) continue;
                filterQueue.add(stackInSlot);
            }
        }
        return filterQueue;
    }

    public void writeFilterQueueToNBT(ItemStack stack, List<ItemStack> listIn) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT compoundStorage = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(listIn.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, listIn.get(i));
        }
        compoundStorage = handler.serializeNBT();
        compound.func_218657_a("filterqueue", (INBT)compoundStorage);
        stack.func_77982_d(compound);
    }

    public List<ItemStack> readFilterQueueFromNBT(ItemStack coin) {
        CompoundNBT getCompound;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("filterqueue")) {
            CompoundNBT invTag = getCompound.func_74775_l("filterqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((INBT)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                filterQueue.add(handler.getStackInSlot(i));
            }
        }
        return filterQueue;
    }

    public boolean doesFilterAndQueueMatch(List<ItemStack> filterIn, List<ItemStack> queueMatch) {
        int matching = 0;
        if (filterIn.size() == queueMatch.size()) {
            for (int i = 0; i < filterIn.size() && this.doItemsMatchWithEmpty(filterIn.get(i), queueMatch.get(i)); ++i) {
                ++matching;
            }
        }
        return matching == filterIn.size();
    }

    @Override
    public void removeInventoryQueue(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("invqueue")) {
            compound.func_82580_o("invqueue");
            stack.func_77982_d(compound);
        }
    }

    public List<ItemStack> buildInventoryQueue(PedestalTileEntity pedestal) {
        IItemHandler handler;
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        BlockState pedestalState = world.func_180495_p(pedestalPos);
        Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos posInventory = this.getPosOfBlockBelow(world, pedestalPos, 1);
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        LazyOptional<IItemHandler> cap = ItemUpgradeBase.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, pedestalPos), true);
        if (this.hasAdvancedInventoryTargeting(coin)) {
            cap = ItemUpgradeBase.findItemHandlerAtPosAdvanced(world, posInventory, this.getPedestalFacing(world, pedestalPos), true);
        }
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i).func_77946_l();
                if (stackInSlot.func_190916_E() > 64) {
                    stackInSlot.func_190920_e(64);
                }
                filterQueue.add(stackInSlot);
            }
        }
        return filterQueue;
    }

    public void writeInventoryQueueToNBT(ItemStack stack, List<ItemStack> listIn) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT tag = new CompoundNBT();
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(listIn.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, listIn.get(i));
        }
        compound = (CompoundNBT)handler.serializeNBT();
        tag.func_218657_a("invqueue", (INBT)compound);
        stack.func_77982_d(tag);
    }

    public List<ItemStack> readInventoryQueueFromNBT(ItemStack coin) {
        CompoundNBT getCompound;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("invqueue")) {
            CompoundNBT invTag = getCompound.func_74775_l("invqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((INBT)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                filterQueue.add(handler.getStackInSlot(i));
            }
        }
        return filterQueue;
    }

    public boolean doInventoryQueuesMatch(List<ItemStack> stackIn, List<ItemStack> stackCurrent) {
        int matching = 0;
        if (stackIn.size() == stackCurrent.size()) {
            for (int i = 0; i < stackCurrent.size() && stackIn.size() >= i && this.doItemsMatchWithEmpty(stackIn.get(i), stackCurrent.get(i)); ++i) {
                ++matching;
            }
        }
        return matching == stackIn.size();
    }

    public static IRecipe<CraftingInventory> findRecipe(CraftingInventory inv, World world) {
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world).orElse(null);
    }

    public int getGridSize(ItemStack itemStack) {
        int gridSize = 0;
        gridSize = itemStack.func_77973_b().equals(ItemUpgradeCrafter.CRAFTER_ONE) ? 1 : (itemStack.func_77973_b().equals(ItemUpgradeCrafter.CRAFTER_TWO) ? 2 : (itemStack.func_77973_b().equals(ItemUpgradeCrafter.CRAFTER_THREE) ? 3 : 1));
        return gridSize;
    }

    public void buildAndWriteCraftingQueue(PedestalTileEntity pedestal, List<ItemStack> inventoryQueue) {
        World world = pedestal.func_145831_w();
        ItemStack coin = pedestal.getCoinOnPedestal();
        int gridSize = this.getGridSize(coin);
        int intGridCount = gridSize * gridSize;
        List<ItemStack> invQueue = inventoryQueue;
        int recipeCount = Math.floorDiv(invQueue.size(), intGridCount);
        ArrayList<ItemStack> recipeQueue = new ArrayList<ItemStack>();
        CraftingInventory craft = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, gridSize, gridSize);
        for (int r = 1; r <= recipeCount; ++r) {
            for (int s = 0; s < intGridCount; ++s) {
                int getActualIndex = r * intGridCount - intGridCount + s;
                ItemStack getStack = invQueue.get(getActualIndex);
                if (getStack.func_190926_b() || getStack.func_77973_b() instanceof ItemCraftingPlaceholder) {
                    craft.func_70299_a(s, ItemStack.field_190927_a);
                    continue;
                }
                craft.func_70299_a(s, getStack);
            }
            if (craft.func_70302_i_() < intGridCount) continue;
            IRecipe<CraftingInventory> recipe = ItemUpgradeBase.findRecipe(craft, world);
            if (recipe != null && recipe.func_77569_a((IInventory)craft, world)) {
                ItemStack stackRecipeResult = recipe.func_77572_b((IInventory)craft);
                recipeQueue.add(stackRecipeResult);
                continue;
            }
            recipeQueue.add(ItemStack.field_190927_a);
        }
        this.writeCraftingQueueToNBT(coin, recipeQueue);
    }

    public void buildOutputIngredientMapFromPattern(PedestalTileEntity pedestal) {
        ItemStack patternStack;
        if (pedestal.hasFilter() && (patternStack = pedestal.getFilterInPedestal()).func_77973_b() instanceof IFilterBase) {
            IFilterBase filterClassItem = (IFilterBase)patternStack.func_77973_b();
            List<ItemStack> patternList = filterClassItem.readFilterQueueFromNBT(patternStack);
            Map<ItemStack, List<ItemStack>> mappedOutputIngredients = this.buildIngredientList(pedestal, patternList);
            this.writeOutputIngredientMapToNBT(pedestal.getCoinOnPedestal(), mappedOutputIngredients);
        }
    }

    public Map<ItemStack, List<ItemStack>> buildIngredientList(PedestalTileEntity pedestal, List<ItemStack> inventoryQueue) {
        World world = pedestal.func_145831_w();
        ItemStack coin = pedestal.getCoinOnPedestal();
        int gridSize = this.getGridSize(coin);
        int intGridCount = gridSize * gridSize;
        List<ItemStack> invQueue = inventoryQueue;
        int recipeCount = Math.floorDiv(invQueue.size(), intGridCount);
        LinkedHashMap ingredientMap = Maps.newLinkedHashMap();
        CraftingInventory craft = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, gridSize, gridSize);
        for (int r = 1; r <= recipeCount; ++r) {
            IRecipe<CraftingInventory> recipe;
            ArrayList<ItemStack> ingredientQueue = new ArrayList<ItemStack>();
            for (int s = 0; s < intGridCount; ++s) {
                int getActualIndex = r * intGridCount - intGridCount + s;
                ItemStack getStack = invQueue.get(getActualIndex);
                if (getStack.func_190926_b() || getStack.func_77973_b() instanceof ItemCraftingPlaceholder) {
                    craft.func_70299_a(s, ItemStack.field_190927_a);
                    continue;
                }
                ItemStack itemInList = ItemStack.field_190927_a;
                itemInList = ingredientQueue.stream().filter(itemStack -> this.doItemsMatch(getStack, (ItemStack)itemStack)).findFirst().orElse(ItemStack.field_190927_a);
                if (!itemInList.func_190926_b()) {
                    int index = ingredientQueue.lastIndexOf(itemInList);
                    if (index > -1) {
                        ItemStack current = (ItemStack)ingredientQueue.remove(index);
                        int countAdded = current.func_190916_E() + getStack.func_190916_E();
                        current.func_190920_e(countAdded);
                        ingredientQueue.add(current);
                    } else {
                        ingredientQueue.add(getStack);
                    }
                } else {
                    ingredientQueue.add(getStack);
                }
                craft.func_70299_a(s, getStack);
            }
            if (craft.func_70302_i_() < intGridCount || (recipe = ItemUpgradeBase.findRecipe(craft, world)) == null || !recipe.func_77569_a((IInventory)craft, world)) continue;
            ItemStack stackRecipeResult = recipe.func_77572_b((IInventory)craft);
            ingredientMap.put(stackRecipeResult, ingredientQueue);
        }
        return ingredientMap;
    }

    public void writeOutputIngredientMapToNBT(ItemStack coin, Map<ItemStack, List<ItemStack>> mapIn) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT tag = new CompoundNBT();
        if (coin.func_77942_o()) {
            tag = coin.func_77978_p();
        }
        ListNBT nbtList = new ListNBT();
        int counter = 0;
        for (Map.Entry<ItemStack, List<ItemStack>> entry : mapIn.entrySet()) {
            ItemStack key = entry.getKey();
            if (key == null) continue;
            List<ItemStack> ingredientList = entry.getValue();
            int handlerSize = ingredientList.size() + 1;
            ItemStackHandler handler = new ItemStackHandler();
            handler.setSize(handlerSize);
            handler.setStackInSlot(0, key);
            for (int i = 0; i < ingredientList.size(); ++i) {
                handler.setStackInSlot(i + 1, ingredientList.get(i));
            }
            compound = (CompoundNBT)handler.serializeNBT();
            nbtList.add(counter, (INBT)compound);
            ++counter;
        }
        coin.func_77983_a("outputIngredientMap", (INBT)nbtList);
    }

    public Map<ItemStack, List<ItemStack>> readOutputIngredientMapFromNBT(ItemStack coin) {
        LinkedHashMap craftingQueue = Maps.newLinkedHashMap();
        if (coin.func_77942_o() && coin.func_77978_p().func_74764_b("outputIngredientMap")) {
            ListNBT getList = coin.func_77978_p().func_150295_c("outputIngredientMap", 10);
            for (int m = 0; m < getList.size(); ++m) {
                ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
                CompoundNBT compoundnbt = getList.func_150305_b(m);
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT((INBT)compoundnbt);
                for (int i = 1; i < handler.getSlots(); ++i) {
                    filterQueue.add(handler.getStackInSlot(i));
                }
                craftingQueue.put(handler.getStackInSlot(0), filterQueue);
            }
        }
        return craftingQueue;
    }

    @Override
    public void removeOutputIngredientMap(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("outputIngredientMap")) {
            compound.func_82580_o("outputIngredientMap");
            stack.func_77982_d(compound);
        }
    }

    public boolean getFilterChangeStatus(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o() && (compound = coin.func_77978_p()).func_74764_b("filterChange")) {
            return compound.func_74767_n("filterChange");
        }
        return false;
    }

    @Override
    public void setFilterChangeUpdate(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
            compound.func_74757_a("filterChange", true);
        } else {
            compound.func_74757_a("filterChange", true);
        }
        coin.func_77982_d(compound);
    }

    public void setFilterChangeUpdated(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
            compound.func_74757_a("filterChange", false);
        }
        coin.func_77982_d(compound);
    }

    @Override
    public void removeFilterChangeUpdated(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o() && (compound = coin.func_77978_p()).func_74764_b("filterChange")) {
            compound.func_82580_o("filterChange");
            coin.func_77982_d(compound);
        }
    }

    public void writeCraftingQueueToNBT(ItemStack stack, List<ItemStack> listIn) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT tag = new CompoundNBT();
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(listIn.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, listIn.get(i));
        }
        compound = (CompoundNBT)handler.serializeNBT();
        tag.func_218657_a("craftqueue", (INBT)compound);
        stack.func_77982_d(tag);
    }

    public List<ItemStack> readCraftingQueueFromNBT(ItemStack coin) {
        CompoundNBT getCompound;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        if (coin.func_77942_o() && (getCompound = coin.func_77978_p()).func_74764_b("craftqueue")) {
            CompoundNBT invTag = getCompound.func_74775_l("craftqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((INBT)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                filterQueue.add(handler.getStackInSlot(i));
            }
        }
        return filterQueue;
    }

    @Override
    public void removeCraftingQueue(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("craftqueue")) {
            compound.func_82580_o("craftqueue");
            stack.func_77982_d(compound);
        }
    }

    @Override
    public void notifyTransferUpdate(PedestalTileEntity receiverTile) {
    }

    @Override
    public void removeFilterBlock(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("blockbelow")) {
            compound.func_82580_o("blockbelow");
            stack.func_77982_d(compound);
        }
    }

    public boolean hasFilterBlock(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        return stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("blockbelow");
    }

    public void writeFilterBlockToNBT(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        BlockPos pedestalPos = pedestal.func_174877_v();
        ItemStack coin = pedestal.getCoinOnPedestal();
        Block blockBelow = this.getBaseBlockBelow(world, pedestalPos);
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
        }
        compound.func_74778_a("blockbelow", blockBelow.getRegistryName() == null ? "minecraft:air" : blockBelow.getRegistryName().toString());
        coin.func_77982_d(compound);
    }

    public Block readFilterBlockFromNBT(ItemStack coin) {
        Block blocked = Blocks.field_150350_a;
        if (coin.func_77942_o()) {
            CompoundNBT getCompound = coin.func_77978_p();
            blocked = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(getCompound.func_74779_i("blockbelow")));
        }
        return blocked;
    }

    @Override
    public void removeStoredIntFromCoin(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("storedint")) {
            compound.func_82580_o("storedint");
            stack.func_77982_d(compound);
        }
    }

    public void writeStoredIntToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("storedint", value);
        stack.func_77982_d(compound);
    }

    public int readStoredIntFromNBT(ItemStack stack) {
        int value = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            value = getCompound.func_74762_e("storedint");
        }
        return value;
    }

    public int getStoredInt(ItemStack coin) {
        return this.readStoredIntFromNBT(coin);
    }

    @Override
    public void removeStoredIntTwoFromCoin(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("storedinttwo")) {
            compound.func_82580_o("storedinttwo");
            stack.func_77982_d(compound);
        }
    }

    public void writeStoredIntTwoToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("storedinttwo", value);
        stack.func_77982_d(compound);
    }

    public int readStoredIntTwoFromNBT(ItemStack stack) {
        int maxenergy = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxenergy = getCompound.func_74762_e("storedinttwo");
        }
        return maxenergy;
    }

    public int getStoredIntTwo(ItemStack coin) {
        return this.readStoredIntTwoFromNBT(coin);
    }

    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{0, 0};
    }

    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return 0;
    }

    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
    }

    public boolean getToolChangeStatus(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o() && (compound = coin.func_77978_p()).func_74764_b("toolChange")) {
            return compound.func_74767_n("toolChange");
        }
        return false;
    }

    public void setToolChangeUpdate(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
            compound.func_74757_a("toolChange", true);
        } else {
            compound.func_74757_a("toolChange", true);
        }
        coin.func_77982_d(compound);
    }

    public void setToolChangeUpdated(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o()) {
            compound = coin.func_77978_p();
            compound.func_74757_a("toolChange", false);
        }
        coin.func_77982_d(compound);
    }

    @Override
    public void removeToolChangeUpdated(ItemStack coin) {
        CompoundNBT compound = new CompoundNBT();
        if (coin.func_77942_o() && (compound = coin.func_77978_p()).func_74764_b("toolChange")) {
            compound.func_82580_o("toolChange");
            coin.func_77982_d(compound);
        }
    }

    @Override
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void spawnParticleAroundPedestalBase(World world, int tick, BlockPos pos, BasicParticleType parti) {
        double dx = pos.func_177958_n();
        double dy = pos.func_177956_o();
        double dz = pos.func_177952_p();
        BlockState state = world.func_180495_p(pos);
        Direction enumfacing = Direction.UP;
        if (state.func_177230_c() instanceof PedestalBlock) {
            enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        switch (enumfacing) {
            case UP: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case DOWN: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.85, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.85, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.85, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.85, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case NORTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.85, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.85, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.85, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.85, 0.0, 0.0, 0.0);
                }
                return;
            }
            case SOUTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.15, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.15, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.15, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.15, 0.0, 0.0, 0.0);
                }
                return;
            }
            case EAST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case WEST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 35 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
        }
        if (tick % 25 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
        }
    }

    public void spawnParticleAroundPedestalBase(World world, int tick, BlockPos pos, float r, float g, float b, float alpha) {
        double dx = pos.func_177958_n();
        double dy = pos.func_177956_o();
        double dz = pos.func_177952_p();
        BlockState state = world.func_180495_p(pos);
        Direction enumfacing = Direction.UP;
        if (state.func_177230_c() instanceof PedestalBlock) {
            enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        BlockPos blockBelow = pos;
        RedstoneParticleData parti = new RedstoneParticleData(r, g, b, alpha);
        switch (enumfacing) {
            case UP: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case DOWN: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.85, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.85, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.85, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.85, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case NORTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.85, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.85, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.85, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.85, 0.0, 0.0, 0.0);
                }
                return;
            }
            case SOUTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.15, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.15, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.15, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.15, 0.0, 0.0, 0.0);
                }
                return;
            }
            case EAST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.15, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case WEST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.85, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 35 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
        }
        if (tick % 25 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.15, dz + 0.75, 0.0, 0.0, 0.0);
        }
    }

    public void spawnParticleAbovePedestal(World world, BlockPos pos, float r, float g, float b, float alpha) {
        double dx = pos.func_177958_n();
        double dy = pos.func_177956_o();
        double dz = pos.func_177952_p();
        BlockState state = world.func_180495_p(pos);
        Direction enumfacing = Direction.UP;
        if (state.func_177230_c() instanceof PedestalBlock) {
            enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        RedstoneParticleData parti = new RedstoneParticleData(r, g, b, alpha);
        switch (enumfacing) {
            case UP: {
                world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 1.0, dz + 0.5, 0.0, 0.0, 0.0);
                return;
            }
            case DOWN: {
                world.func_195594_a((IParticleData)parti, dx + 0.5, dy - 1.0, dz + 0.5, 0.0, 0.0, 0.0);
                return;
            }
            case NORTH: {
                world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.5, dz - 1.0, 0.0, 0.0, 0.0);
                return;
            }
            case SOUTH: {
                world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.5, dz + 1.0, 0.0, 0.0, 0.0);
                return;
            }
            case EAST: {
                world.func_195594_a((IParticleData)parti, dx + 1.0, dy + 0.5, dz + 0.5, 0.0, 0.0, 0.0);
                return;
            }
            case WEST: {
                world.func_195594_a((IParticleData)parti, dx - 1.0, dy + 0.5, dz + 0.5, 0.0, 0.0, 0.0);
                return;
            }
        }
        world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 1.0, dz + 0.5, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        PedestalTileEntity pedestal;
        ItemStack itemstack;
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity && !(itemstack = (pedestal = (PedestalTileEntity)tileEntity).getItemInPedestal()).func_190926_b()) {
            float f = (float)itemstack.func_190916_E() / (float)Math.min(pedestal.maxStackSize(), itemstack.func_77976_d());
            intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
    }

    @Override
    public void actionOnCollideWithBlock(PedestalTileEntity tilePedestal, Entity entityIn) {
        World world = tilePedestal.func_145831_w();
        BlockPos posPedestal = tilePedestal.func_174877_v();
        BlockState state = world.func_180495_p(posPedestal);
        this.actionOnCollideWithBlock(world, tilePedestal, posPedestal, state, entityIn);
    }

    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
    }
}

