/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.google.common.collect.Multimap;
import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeAttacker
extends ItemUpgradeBase {
    public static final Item ATTACK = (Item)new ItemUpgradeAttacker(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/attack"));

    public ItemUpgradeAttacker(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptMagnet() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getRangeHeight(ItemStack stack) {
        return this.getHeight(stack);
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getRangeHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    public float getSwordDamage(LivingEntity entityIn, ItemStack toolInPedestal) {
        AttributeModifier collected;
        float damage = 2.0f;
        Multimap attributes = toolInPedestal.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, toolInPedestal);
        if (attributes.containsKey((Object)Attributes.field_233823_f_) && attributes.get((Object)Attributes.field_233823_f_).size() > 0 && (collected = (AttributeModifier)attributes.get((Object)Attributes.field_233823_f_).iterator().next()).func_111164_d() > (double)damage) {
            damage = (float)((double)damage + collected.func_111164_d());
        }
        if (entityIn instanceof SpiderEntity && EnchantmentHelper.func_82781_a((ItemStack)toolInPedestal).containsKey(Enchantments.field_180312_n)) {
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180312_n, (ItemStack)toolInPedestal);
            damage = (float)((double)damage + (1.0 + (double)lvl * 0.5));
        }
        if (entityIn instanceof ZombieEntity || entityIn instanceof SkeletonEntity && EnchantmentHelper.func_82781_a((ItemStack)toolInPedestal).containsKey(Enchantments.field_185303_l)) {
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185303_l, (ItemStack)toolInPedestal);
            damage = (float)((double)damage + (1.0 + (double)lvl * 0.5));
        }
        return damage;
    }

    public float getAttackDamage(LivingEntity entityIn, ItemStack toolInPedestal, ItemStack coinInPedestal) {
        float damage = (float)(this.getCapacityModifier(coinInPedestal) * 2) + 2.0f;
        return damage += this.getSwordDamage(entityIn, toolInPedestal);
    }

    public float getMostlyDamage(PedestalTileEntity pedestal) {
        ToolItem tool;
        ItemStack inPedestal = pedestal.getToolOnPedestal();
        float damage = (float)this.getCapacityModifier(pedestal.getCoinOnPedestal()) + 2.0f;
        float damage2 = 2.0f;
        if (inPedestal.func_77973_b() instanceof SwordItem) {
            SwordItem sword = (SwordItem)inPedestal.func_77973_b();
            if (sword.func_200894_d() > damage2) {
                damage += sword.func_200894_d() / 2.0f;
            }
        } else if (inPedestal.func_77973_b() instanceof ToolItem && (tool = (ToolItem)inPedestal.func_77973_b()).func_234675_d_() > damage2) {
            damage += tool.func_234675_d_() / 2.0f;
        }
        if (EnchantmentHelper.func_82781_a((ItemStack)inPedestal).containsKey(Enchantments.field_185302_k)) {
            int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)inPedestal);
            damage += (float)Math.round((1.0 + (double)lvl * 0.5) / 2.0);
        }
        return damage;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        BlockPos pedestalPos;
        if (!world.field_72995_K && !pedestal.isPedestalBlockPowered(world, pedestalPos = pedestal.func_174877_v())) {
            BlockPos posBlockPos;
            BlockPos negBlockPos;
            AxisAlignedBB getBox;
            List itemList;
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            int width = this.getAreaWidth(coinInPedestal);
            int height = this.getRangeHeight(coinInPedestal);
            if (this.hasMagnetEnchant(coinInPedestal) && (itemList = world.func_217357_a(ItemEntity.class, getBox = new AxisAlignedBB(negBlockPos = this.getNegRangePosEntity(world, pedestalPos, width, height), posBlockPos = this.getPosRangePosEntity(world, pedestalPos, width, height)))).size() > 0) {
                this.upgradeActionMagnet(pedestal, world, itemList, itemInPedestal, pedestalPos);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        int width = this.getAreaWidth(coinInPedestal);
        int height = this.getRangeHeight(coinInPedestal);
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
        if (!this.hasFilterBlock(coinInPedestal)) {
            this.writeFilterBlockToNBT(pedestal);
        }
        Block filterBlock = this.readFilterBlockFromNBT(coinInPedestal);
        List itemList = world.func_217357_a(LivingEntity.class, getBox);
        for (LivingEntity getEntityFromList : itemList) {
            FakePlayer fakePlayer;
            List<String> list = Arrays.asList("pedestal1", "pedestal2", "pedestal3", "pedestal4", "pedestal5", "pedestal6", "pedestal7", "pedestal8", "pedestal9", "pedestal10", "pedestal11", "pedestal12");
            Random rn = new Random();
            LivingEntity selectedEntity = this.getTargetEntity(filterBlock, getEntityFromList);
            if (selectedEntity == null || (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) == null) continue;
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
            }
            if (pedestal.hasTool() && !fakePlayer.func_184614_ca().equals(toolInPedestal)) {
                fakePlayer.func_184611_a(Hand.MAIN_HAND, toolInPedestal);
            }
            if (toolInPedestal.func_190926_b() && !fakePlayer.func_184614_ca().equals(toolInPedestal)) {
                fakePlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            EntityDamageSource sourceE = new EntityDamageSource(list.get(rn.nextInt(list.size())), (Entity)fakePlayer);
            float damage = this.getAttackDamage(getEntityFromList, toolInPedestal, coinInPedestal);
            if (filterBlock.equals(Blocks.field_235397_ng_)) {
                damage *= 2.0f;
            }
            selectedEntity.func_70097_a((DamageSource)sourceE, damage);
        }
    }

    @Override
    public void onPedestalBelowNeighborChanged(PedestalTileEntity pedestal, BlockState blockChanged, BlockPos blockChangedPos) {
        BlockPos blockBelow = this.getPosOfBlockBelow(pedestal.func_145831_w(), pedestal.func_174877_v(), 1);
        if (blockBelow.equals((Object)blockChangedPos)) {
            this.writeFilterBlockToNBT(pedestal);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        Map map;
        ItemStack toolStack;
        ItemStack stack = pedestal.getCoinOnPedestal();
        Block filterBlock = this.hasFilterBlock(stack) ? this.readFilterBlockFromNBT(stack) : Blocks.field_150350_a;
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getRangeHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getMostlyDamage(pedestal) + "");
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        ItemStack itemStack = toolStack = pedestal.hasTool() ? pedestal.getToolOnPedestal() : ItemStack.field_190927_a;
        if (!toolStack.func_190926_b()) {
            TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".chat_tool");
            tool.func_230529_a_(toolStack.func_200301_q());
            tool.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        }
        if ((map = EnchantmentHelper.func_82781_a((ItemStack)(pedestal.hasTool() ? pedestal.getToolOnPedestal() : stack))).size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent entityType = new TranslationTextComponent(this.func_77658_a() + ".chat_entity");
        entityType.func_240702_b_(this.getTargetEntity(filterBlock));
        entityType.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)entityType, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getRangeHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + (int)((float)this.getCapacityModifier(stack) + 2.0f) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ATTACK);
    }
}

