/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalFilters;

import com.mowmaster.pedestals.api.filter.IFilterBase;
import com.mowmaster.pedestals.item.pedestalFilters.ItemFilterBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemFilterEnchantedFuzzy
extends ItemFilterBase {
    public static final Item ENCHANTEDFUZZYFILTER = (Item)new ItemFilterEnchantedFuzzy(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "filter/filterenchantedfuzzy"));

    public ItemFilterEnchantedFuzzy(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptItem(PedestalTileEntity pedestal, ItemStack itemStackIn) {
        boolean filterBool;
        boolean returner = filterBool = this.getFilterType(pedestal.getFilterInPedestal());
        if (itemStackIn.func_77948_v() || itemStackIn.func_77973_b().equals(Items.field_151134_bR)) {
            ItemStack filter = pedestal.getFilterInPedestal();
            List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter);
            int range = stackCurrent.size();
            Map mapIncomming = EnchantmentHelper.func_82781_a((ItemStack)itemStackIn);
            for (Map.Entry entry : mapIncomming.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                ItemStack itemFromInv = ItemStack.field_190927_a;
                itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.func_77948_v() || itemStack.func_77973_b().equals(Items.field_151134_bR)).filter(itemStack -> EnchantmentHelper.func_82781_a((ItemStack)itemStack).containsKey(enchantment)).findFirst().orElse(ItemStack.field_190927_a);
                if (itemFromInv.func_190926_b()) continue;
                returner = !filterBool;
            }
        }
        return returner;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        RayTraceResult result = p_77659_2_.func_213324_a(5.0, 0.0f, false);
        if (result != null) {
            ItemStack itemInHand;
            if (result.func_216346_c() == RayTraceResult.Type.MISS && p_77659_2_.func_213453_ef()) {
                ItemStack itemInHand2 = p_77659_2_.func_184586_b(p_77659_3_);
                if (itemInHand2.func_77973_b() instanceof IFilterBase) {
                    boolean getCurrentType = this.getFilterType(itemInHand2);
                    this.setFilterType(itemInHand2, !getCurrentType);
                    TranslationTextComponent changed = new TranslationTextComponent("pedestals.filters.tooltip_filterchange");
                    changed.func_240699_a_(TextFormatting.GREEN);
                    TranslationTextComponent white = new TranslationTextComponent("pedestals.filters.tooltip_filterwhite");
                    TranslationTextComponent black = new TranslationTextComponent("pedestals.filters.tooltip_filterblack");
                    changed.func_230529_a_((ITextComponent)(!getCurrentType ? black : white));
                    p_77659_2_.func_146105_b((ITextComponent)changed, true);
                    return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
                }
                return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK && p_77659_2_.func_213453_ef() && (itemInHand = p_77659_2_.func_184586_b(p_77659_3_)).func_77973_b() instanceof IFilterBase) {
                ItemUseContext context = new ItemUseContext(p_77659_2_, p_77659_3_, (BlockRayTraceResult)result);
                BlockRayTraceResult res = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), false);
                BlockPos posBlock = res.func_216350_a();
                List<ItemStack> buildQueue = this.buildFilterQueue(p_77659_1_, posBlock);
                if (buildQueue.size() > 0) {
                    this.writeFilterQueueToNBT(itemInHand, buildQueue);
                    return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
                }
                return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack filterStack = pedestal.getFilterInPedestal();
        TranslationTextComponent filterList = new TranslationTextComponent(filterStack.func_200301_q().getString());
        filterList.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)filterList, Util.field_240973_b_);
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack);
        if (filterQueue.size() > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (int i = 0; i < filterQueue.size(); ++i) {
                if (filterQueue.get(i).func_190926_b()) continue;
                Map mapIncomming = EnchantmentHelper.func_82781_a((ItemStack)filterQueue.get(i));
                for (Map.Entry entry : mapIncomming.entrySet()) {
                    TranslationTextComponent enchants = new TranslationTextComponent(((Enchantment)entry.getKey()).func_77320_a());
                    enchants.func_240699_a_(TextFormatting.GRAY);
                    player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean filterType = this.getFilterType(stack);
        TranslationTextComponent filterList = new TranslationTextComponent("pedestals.filters.tooltip_filtertype");
        TranslationTextComponent white = new TranslationTextComponent("pedestals.filters.tooltip_filterwhite");
        TranslationTextComponent black = new TranslationTextComponent("pedestals.filters.tooltip_filterblack");
        filterList.func_230529_a_((ITextComponent)(filterType ? black : white));
        filterList.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)filterList);
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(stack);
        if (filterQueue.size() > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            tooltip.add((ITextComponent)enchant);
            for (int i = 0; i < filterQueue.size(); ++i) {
                if (filterQueue.get(i).func_190926_b()) continue;
                Map mapIncomming = EnchantmentHelper.func_82781_a((ItemStack)filterQueue.get(i));
                for (Map.Entry entry : mapIncomming.entrySet()) {
                    TranslationTextComponent enchants = new TranslationTextComponent(((Enchantment)entry.getKey()).func_77320_a());
                    enchants.func_240699_a_(TextFormatting.GRAY);
                    tooltip.add((ITextComponent)enchants);
                }
            }
        }
    }

    public static void handleItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((itemstack, tintIndex) -> {
            if (tintIndex == 1) {
                return ItemFilterEnchantedFuzzy.getColorFromNBT(itemstack);
            }
            return -1;
        }, new IItemProvider[]{ENCHANTEDFUZZYFILTER});
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ENCHANTEDFUZZYFILTER);
    }
}

