/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalFilters;

import com.mowmaster.pedestals.item.pedestalFilters.ItemFilterBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemCraftingPattern
extends ItemFilterBase {
    public static final Item CRAFTINGPATTERN = (Item)new ItemCraftingPattern(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "filter/craftingpattern"));

    public ItemCraftingPattern(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public List<ItemStack> buildFilterQueue(World world, BlockPos invBlock) {
        IItemHandler handler;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        LazyOptional<IItemHandler> cap = ItemCraftingPattern.findItemHandlerAtPos(world, invBlock, true);
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                filterQueue.add(stackInSlot);
            }
        }
        return filterQueue;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack filterStack = pedestal.getFilterInPedestal();
        TranslationTextComponent filterList = new TranslationTextComponent(filterStack.func_200301_q().getString());
        filterList.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)filterList, Util.field_240973_b_);
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack);
        if (filterQueue.size() > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (int i = 0; i < filterQueue.size(); ++i) {
                TranslationTextComponent enchants = new TranslationTextComponent(filterQueue.get(i).func_200301_q().getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean filterType = this.getFilterType(stack);
        TranslationTextComponent filterList = new TranslationTextComponent("pedestals.filters.tooltip_filtertype");
        TranslationTextComponent white = new TranslationTextComponent("pedestals.filters.tooltip_filterwhite");
        TranslationTextComponent black = new TranslationTextComponent("pedestals.filters.tooltip_filterblack");
        filterList.func_230529_a_((ITextComponent)(filterType ? black : white));
        filterList.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)filterList);
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(stack);
        if (filterQueue.size() > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent("pedestals.filters.tooltip_filterlist");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            tooltip.add((ITextComponent)enchant);
            for (int i = 0; i < filterQueue.size(); ++i) {
                TranslationTextComponent enchants = new TranslationTextComponent(filterQueue.get(i).func_200301_q().getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                tooltip.add((ITextComponent)enchants);
            }
        }
    }

    public static void handleItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((itemstack, tintIndex) -> {
            if (tintIndex == 1) {
                return 255;
            }
            return -1;
        }, new IItemProvider[]{CRAFTINGPATTERN});
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)CRAFTINGPATTERN);
    }
}

