/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item;

import com.google.common.collect.Maps;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.ItemToolSwapper;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeTool
extends Item {
    private static final BlockPos defaultPos = new BlockPos(0, -2000, 0);
    public BlockPos storedPosition = defaultPos;
    int ticker = 0;
    public static final Item UPGRADE = (Item)new ItemUpgradeTool().setRegistryName(new ResourceLocation("pedestals", "upgradetool"));

    public ItemUpgradeTool() {
        super(new Item.Properties().func_200917_a(1).func_200919_a(UPGRADE).func_200916_a(pedestals.PEDESTALS_TAB));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.func_77973_b() instanceof ItemUpgradeTool || wearer.func_184614_ca().func_77973_b() instanceof ItemUpgradeTool ? true : wearer.func_184592_cb().func_77973_b() instanceof ItemUpgradeTool;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack((IItemProvider)this.getItem());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        if (!worldIn.field_72995_K) {
            Item coinInPed;
            PedestalTileEntity tilePedestal;
            TileEntity tileEntity;
            BlockState getBlockState = worldIn.func_180495_p(pos);
            if (player.func_213453_ef()) {
                if (getBlockState.func_177230_c() instanceof PedestalBlock) {
                    ItemStack coin;
                    PedestalTileEntity ped;
                    TileEntity tile = worldIn.func_175625_s(pos);
                    if (tile instanceof PedestalTileEntity && (ped = (PedestalTileEntity)worldIn.func_175625_s(pos)).hasCoin() && (coin = ped.getCoinOnPedestal()).func_77973_b() instanceof ItemUpgradeBase) {
                        int workX = ((ItemUpgradeBase)coin.func_77973_b()).getWorkAreaX(worldIn, pos, coin);
                        int workY = ((ItemUpgradeBase)coin.func_77973_b()).getWorkAreaY(worldIn, pos, coin)[0];
                        int workZ = ((ItemUpgradeBase)coin.func_77973_b()).getWorkAreaZ(worldIn, pos, coin);
                        int workSingle = ((ItemUpgradeBase)coin.func_77973_b()).getWorkAreaY(worldIn, pos, coin)[1];
                        if (workX + workY + workZ > 0 && !player.func_184614_ca().func_77948_v()) {
                            this.storedPosition = pos;
                            this.writePosToNBT(player.func_184614_ca());
                            this.writeWorkPosToNBT(player.func_184614_ca(), workX, workY, workZ, workSingle);
                            if (player.func_184614_ca().func_77973_b() instanceof ItemUpgradeTool) {
                                player.func_184614_ca().func_77966_a(Enchantments.field_185307_s, -1);
                            }
                        }
                    }
                } else {
                    this.storedPosition = defaultPos;
                    this.writePosToNBT(player.func_184614_ca());
                    this.writeWorkPosToNBT(player.func_184614_ca(), 0, 0, 0, 0);
                    if (player.func_184614_ca().func_77973_b() instanceof ItemUpgradeTool && player.func_184614_ca().func_77973_b() instanceof ItemUpgradeTool && player.func_184614_ca().func_77948_v()) {
                        LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                        EnchantmentHelper.func_82782_a((Map)enchantsNone, (ItemStack)player.func_184614_ca());
                    }
                }
            } else if (worldIn.func_180495_p(pos).func_177230_c() instanceof PedestalBlock && (tileEntity = worldIn.func_175625_s(pos)) instanceof PedestalTileEntity && (tilePedestal = (PedestalTileEntity)tileEntity).hasCoin() && (coinInPed = tilePedestal.getCoinOnPedestal().func_77973_b()) instanceof ItemUpgradeBase) {
                ((ItemUpgradeBase)coinInPed).chatDetails(player, tilePedestal);
            }
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        RayTraceResult result = p_77659_2_.func_213324_a(5.0, 0.0f, false);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.MISS && !p_77659_1_.field_72995_K && p_77659_2_.func_213453_ef()) {
            ItemStack heldItem = p_77659_2_.func_184586_b(p_77659_3_);
            if (heldItem.func_77973_b().equals(UPGRADE) && !heldItem.func_77948_v()) {
                p_77659_2_.func_184611_a(p_77659_3_, new ItemStack((IItemProvider)ItemToolSwapper.QUARRYTOOL));
                TranslationTextComponent range = new TranslationTextComponent("pedestals.tool_change");
                range.func_240699_a_(TextFormatting.GREEN);
                p_77659_2_.func_146105_b((ITextComponent)range, true);
                return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if ((stack.func_77948_v() && isSelected || player.func_184592_cb().func_77973_b() instanceof ItemUpgradeTool) && stack.func_77942_o()) {
                this.getPosFromNBT(stack);
                BlockPos pos = this.getStoredPosition(stack);
                int[] getWorkArea = this.getWorkPosFromNBT(stack);
                Random rand = new Random();
                BlockPos negNums = pos;
                BlockPos posNums = pos;
                if (worldIn.isAreaLoaded(pos, 1) && worldIn.func_175625_s(pos) instanceof PedestalTileEntity) {
                    negNums = this.getNegRangePos(worldIn, pos, getWorkArea[0], getWorkArea[1]);
                    posNums = this.getPosRangePos(worldIn, pos, getWorkArea[0], getWorkArea[1]);
                }
                if (this.storedPosition != defaultPos && isSelected && worldIn.field_72995_K) {
                    ++this.ticker;
                    if (getWorkArea[3] <= 0) {
                        if (this.ticker > 30) {
                            for (int x = negNums.func_177958_n(); x <= posNums.func_177958_n(); ++x) {
                                for (int z = negNums.func_177952_p(); z <= posNums.func_177952_p(); ++z) {
                                    for (int y = negNums.func_177956_o(); y <= posNums.func_177956_o(); ++y) {
                                        BlockPos blockToParti = new BlockPos(x, y, z);
                                        worldIn.func_195590_a((IParticleData)ParticleTypes.field_239813_am_, true, (double)((float)blockToParti.func_177958_n() + 0.5f), (double)((float)blockToParti.func_177956_o() + 0.5f), (double)((float)blockToParti.func_177952_p() + 0.5f), rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005);
                                    }
                                }
                            }
                            this.ticker = 0;
                        }
                    } else {
                        BlockPos blockToParti = new BlockPos(getWorkArea[0], getWorkArea[1], getWorkArea[2]);
                        this.spawnParticleAroundPedestalBase(worldIn, this.ticker, blockToParti, 0.0f, 0.0f, 0.0f, 1.0f);
                    }
                }
            }
        }
    }

    public BlockPos getStoredPosition(ItemStack getWrenchItem) {
        this.getPosFromNBT(getWrenchItem);
        return this.storedPosition;
    }

    public void writePosToNBT(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("stored_x", this.storedPosition.func_177958_n());
        compound.func_74768_a("stored_y", this.storedPosition.func_177956_o());
        compound.func_74768_a("stored_z", this.storedPosition.func_177952_p());
        stack.func_77982_d(compound);
    }

    public void writeWorkPosToNBT(ItemStack stack, int x, int y, int z, int single) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("work_x", x);
        compound.func_74768_a("work_y", y);
        compound.func_74768_a("work_z", z);
        compound.func_74768_a("work_single", single);
        stack.func_77982_d(compound);
    }

    public void getPosFromNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            int x = getCompound.func_74762_e("stored_x");
            int y = getCompound.func_74762_e("stored_y");
            int z = getCompound.func_74762_e("stored_z");
            this.storedPosition = new BlockPos(x, y, z);
        }
    }

    public int[] getWorkPosFromNBT(ItemStack stack) {
        int x = 0;
        int y = 0;
        int z = 0;
        int single = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            x = getCompound.func_74762_e("work_x");
            y = getCompound.func_74762_e("work_y");
            z = getCompound.func_74762_e("work_z");
            single = getCompound.func_74762_e("work_single");
        }
        return new int[]{x, y, z, single};
    }

    public BlockPos getNegRangePos(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(-intWidth, 0, -intWidth);
            }
            case DOWN: {
                return blockBelow.func_177982_a(-intWidth, -intHeight, -intWidth);
            }
            case NORTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, -intHeight);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(-intWidth, -intWidth, 0);
            }
            case EAST: {
                return blockBelow.func_177982_a(0, -intWidth, -intWidth);
            }
            case WEST: {
                return blockBelow.func_177982_a(-intHeight, -intWidth, -intWidth);
            }
        }
        return blockBelow;
    }

    public BlockPos getPosRangePos(World world, BlockPos posOfPedestal, int intWidth, int intHeight) {
        BlockState state = world.func_180495_p(posOfPedestal);
        Direction enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.func_177982_a(intWidth, intHeight, intWidth);
            }
            case DOWN: {
                return blockBelow.func_177982_a(intWidth, 0, intWidth);
            }
            case NORTH: {
                return blockBelow.func_177982_a(intWidth, intWidth, 0);
            }
            case SOUTH: {
                return blockBelow.func_177982_a(intWidth, intWidth, intHeight);
            }
            case EAST: {
                return blockBelow.func_177982_a(intHeight, intWidth, intWidth);
            }
            case WEST: {
                return blockBelow.func_177982_a(0, intWidth, intWidth);
            }
        }
        return blockBelow;
    }

    public void spawnParticleAroundPedestalBase(World world, int tick, BlockPos pos, float r, float g, float b, float alpha) {
        double dx = pos.func_177958_n();
        double dy = pos.func_177956_o();
        double dz = pos.func_177952_p();
        BlockState state = world.func_180495_p(pos);
        Direction enumfacing = Direction.UP;
        if (state.func_177230_c() instanceof PedestalBlock) {
            enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        RedstoneParticleData parti = new RedstoneParticleData(r, g, b, alpha);
        switch (enumfacing) {
            case UP: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case DOWN: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case NORTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                return;
            }
            case SOUTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                return;
            }
            case EAST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case WEST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 35 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
        }
        if (tick % 25 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TranslationTextComponent selected = new TranslationTextComponent(this.func_77658_a() + ".tool_block_selected");
        TranslationTextComponent unselected = new TranslationTextComponent(this.func_77658_a() + ".tool_block_unselected");
        TranslationTextComponent cordX = new TranslationTextComponent(this.func_77658_a() + ".tool_X");
        TranslationTextComponent cordY = new TranslationTextComponent(this.func_77658_a() + ".tool_Y");
        TranslationTextComponent cordZ = new TranslationTextComponent(this.func_77658_a() + ".tool_Z");
        if (stack.func_77973_b() instanceof ItemUpgradeTool) {
            if (stack.func_77942_o()) {
                if (stack.func_77948_v()) {
                    selected.func_240702_b_(cordX.getString());
                    selected.func_240702_b_("" + this.getStoredPosition(stack).func_177958_n() + "");
                    selected.func_240702_b_(cordY.getString());
                    selected.func_240702_b_("" + this.getStoredPosition(stack).func_177956_o() + "");
                    selected.func_240702_b_(cordZ.getString());
                    selected.func_240702_b_("" + this.getStoredPosition(stack).func_177952_p() + "");
                    tooltip.add((ITextComponent)selected);
                } else {
                    tooltip.add((ITextComponent)unselected);
                }
            } else {
                tooltip.add((ITextComponent)unselected);
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)UPGRADE);
    }
}

