/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item;

import com.google.common.collect.Maps;
import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.ItemLinkingTool;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemLinkingToolBackwards
extends ItemLinkingTool {
    public static final BlockPos defaultPos = new BlockPos(0, -2000, 0);
    public BlockPos storedPosition = defaultPos;
    public List<BlockPos> storedPositionList = new ArrayList<BlockPos>();
    public static final Item DEFAULT = (Item)new ItemLinkingToolBackwards().setRegistryName(new ResourceLocation("pedestals", "linkingtoolbackwards"));

    @Override
    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack((IItemProvider)this.getItem());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        List<BlockPos> getLocations;
        World worldIn = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        TranslationTextComponent linksucess = new TranslationTextComponent(this.func_77658_a() + ".tool_link_success");
        linksucess.func_240699_a_(TextFormatting.WHITE);
        TranslationTextComponent linkunsuccess = new TranslationTextComponent(this.func_77658_a() + ".tool_link_unsucess");
        linkunsuccess.func_240699_a_(TextFormatting.WHITE);
        TranslationTextComponent linkremoved = new TranslationTextComponent(this.func_77658_a() + ".tool_link_removed");
        linkremoved.func_240699_a_(TextFormatting.WHITE);
        TranslationTextComponent linkitsself = new TranslationTextComponent(this.func_77658_a() + ".tool_link_itsself");
        linkitsself.func_240699_a_(TextFormatting.WHITE);
        TranslationTextComponent linknetwork = new TranslationTextComponent(this.func_77658_a() + ".tool_link_network");
        linknetwork.func_240699_a_(TextFormatting.WHITE);
        TranslationTextComponent linkdistance = new TranslationTextComponent(this.func_77658_a() + ".tool_link_distance");
        linkdistance.func_240699_a_(TextFormatting.WHITE);
        if (worldIn.field_72995_K) return super.func_195939_a(context);
        BlockState getBlockState = worldIn.func_180495_p(pos);
        if (player.func_213453_ef()) {
            if (!(getBlockState.func_177230_c() instanceof PedestalBlock)) {
                if (getBlockState.func_177230_c().equals(Blocks.field_150350_a)) return ActionResultType.FAIL;
                this.storedPosition = defaultPos;
                this.storedPositionList = new ArrayList<BlockPos>();
                this.writePosToNBT(player.func_184614_ca());
                this.writePosListToNBT(player.func_184614_ca());
                worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
                if (!(player.func_184614_ca().func_77973_b() instanceof ItemLinkingTool)) return ActionResultType.FAIL;
                if (!player.func_184614_ca().func_77948_v()) return ActionResultType.FAIL;
                LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                EnchantmentHelper.func_82782_a((Map)enchantsNone, (ItemStack)player.func_184614_ca());
                return ActionResultType.SUCCESS;
            }
            if (!player.func_184614_ca().func_77948_v()) {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof PedestalTileEntity) {
                    PedestalTileEntity ped = (PedestalTileEntity)tile;
                    this.storedPositionList = ped.getLocationList();
                }
                this.storedPosition = pos;
                this.writePosToNBT(player.func_184614_ca());
                this.writePosListToNBT(player.func_184614_ca());
                if (!player.func_184614_ca().func_77973_b().equals(DEFAULT)) return ActionResultType.SUCCESS;
                player.func_184614_ca().func_77966_a(Enchantments.field_185307_s, -1);
                return ActionResultType.SUCCESS;
            }
            if (!player.func_184614_ca().func_77942_o()) return ActionResultType.FAIL;
            if (!player.func_184614_ca().func_77948_v()) return ActionResultType.FAIL;
            BlockPos senderPos = this.getStoredPosition(player.func_184614_ca());
            if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof PedestalBlock)) return ActionResultType.FAIL;
            TileEntity tileSender = worldIn.func_175625_s(senderPos);
            if (!(tileSender instanceof PedestalTileEntity)) return ActionResultType.FAIL;
            PedestalTileEntity senderPedestal = (PedestalTileEntity)tileSender;
            if (!this.isPedestalInRange(senderPedestal, pos)) {
                player.func_145747_a((ITextComponent)linkdistance, Util.field_240973_b_);
                return ActionResultType.FAIL;
            }
            if (!senderPedestal.canLinkToPedestalNetwork(pos)) {
                player.func_145747_a((ITextComponent)linknetwork, Util.field_240973_b_);
                return ActionResultType.FAIL;
            }
            if (senderPedestal.isSamePedestal(pos)) {
                player.func_145747_a((ITextComponent)linkitsself, Util.field_240973_b_);
                return ActionResultType.FAIL;
            }
            if (!senderPedestal.isAlreadyLinked(pos)) {
                if (!senderPedestal.storeNewLocation(pos)) {
                    player.func_145747_a((ITextComponent)linkunsuccess, Util.field_240973_b_);
                    return ActionResultType.FAIL;
                }
                this.storedPosition = defaultPos;
                this.storedPositionList = new ArrayList<BlockPos>();
                this.writePosToNBT(player.func_184614_ca());
                this.writePosListToNBT(player.func_184614_ca());
                worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
                if (player.func_184614_ca().func_77973_b().equals(DEFAULT) && player.func_184614_ca().func_77948_v()) {
                    LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                    EnchantmentHelper.func_82782_a((Map)enchantsNone, (ItemStack)player.func_184614_ca());
                }
                player.func_145747_a((ITextComponent)linksucess, Util.field_240973_b_);
                return ActionResultType.SUCCESS;
            }
            senderPedestal.removeLocation(pos);
            if (player.func_184614_ca().func_77973_b().equals(DEFAULT) && player.func_184614_ca().func_77948_v()) {
                LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                EnchantmentHelper.func_82782_a((Map)enchantsNone, (ItemStack)player.func_184614_ca());
            }
            player.func_145747_a((ITextComponent)linkremoved, Util.field_240973_b_);
            return ActionResultType.SUCCESS;
        }
        if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof PedestalBlock)) return super.func_195939_a(context);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof PedestalTileEntity)) return ActionResultType.SUCCESS;
        PedestalTileEntity tilePedestal = (PedestalTileEntity)tileEntity;
        TranslationTextComponent rrobin = new TranslationTextComponent(this.func_77658_a() + ".tool_rrobin");
        TranslationTextComponent rrobint = new TranslationTextComponent(this.func_77658_a() + ".tool_rrobin_true");
        TranslationTextComponent rrobinf = new TranslationTextComponent(this.func_77658_a() + ".tool_rrobin_false");
        TranslationTextComponent TransferTypeText = tilePedestal.hasRRobin() ? rrobint : rrobinf;
        rrobin.func_230529_a_((ITextComponent)TransferTypeText);
        rrobin.func_240699_a_(TextFormatting.LIGHT_PURPLE);
        player.func_145747_a((ITextComponent)rrobin, Util.field_240973_b_);
        if (tilePedestal.hasTool()) {
            TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".tool_stored");
            tool.func_230529_a_(tilePedestal.getToolOnPedestal().func_200301_q());
            tool.func_240699_a_(TextFormatting.WHITE);
            player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        }
        if (tilePedestal.getSpeed() > 0) {
            TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tool_speed");
            speed.func_240702_b_("" + tilePedestal.getSpeed() + "");
            speed.func_240699_a_(TextFormatting.RED);
            player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
        }
        if (tilePedestal.getCapacity() > 0) {
            TranslationTextComponent capacity = new TranslationTextComponent(this.func_77658_a() + ".tool_capacity");
            capacity.func_240702_b_("" + tilePedestal.getCapacity() + "");
            capacity.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)capacity, Util.field_240973_b_);
        }
        if (tilePedestal.getCapacity() > 0) {
            TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".tool_range");
            range.func_240702_b_("" + tilePedestal.getRange() + "");
            range.func_240699_a_(TextFormatting.GREEN);
            player.func_145747_a((ITextComponent)range, Util.field_240973_b_);
        }
        if ((getLocations = tilePedestal.getLocationList()).size() <= 0) return ActionResultType.SUCCESS;
        TranslationTextComponent links = new TranslationTextComponent(this.func_77658_a() + ".tool_linked");
        links.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)links, Util.field_240973_b_);
        int i = 0;
        while (i < getLocations.size()) {
            TranslationTextComponent linked = new TranslationTextComponent("   " + getLocations.get(i).func_177958_n() + "");
            TranslationTextComponent seperator = new TranslationTextComponent(this.func_77658_a() + ".tool_seperator");
            linked.func_240702_b_(seperator.getString());
            linked.func_240702_b_("" + getLocations.get(i).func_177956_o() + "");
            linked.func_240702_b_(seperator.getString());
            linked.func_240702_b_("" + getLocations.get(i).func_177952_p() + "");
            linked.func_240699_a_(TextFormatting.GRAY);
            player.func_145747_a((ITextComponent)linked, Util.field_240973_b_);
            ++i;
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        RayTraceResult result = p_77659_2_.func_213324_a(5.0, 0.0f, false);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.MISS && p_77659_2_.func_213453_ef()) {
            ItemStack heldItem = p_77659_2_.func_184586_b(p_77659_3_);
            if (heldItem.func_77973_b().equals(DEFAULT) && !heldItem.func_77948_v()) {
                p_77659_2_.func_184611_a(p_77659_3_, new ItemStack((IItemProvider)ItemLinkingTool.DEFAULT));
                TranslationTextComponent range = new TranslationTextComponent("pedestals.tool_change");
                range.func_240699_a_(TextFormatting.GREEN);
                p_77659_2_.func_146105_b((ITextComponent)range, true);
                return ActionResult.func_226248_a_((Object)p_77659_2_.func_184586_b(p_77659_3_));
            }
            return ActionResult.func_226251_d_((Object)p_77659_2_.func_184586_b(p_77659_3_));
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if (stack.func_77948_v() && isSelected && stack.func_77942_o()) {
                this.getPosFromNBT(stack);
                List<BlockPos> storedRecievers = this.getStoredPositionList(stack);
                int locationsNum = storedRecievers.size();
                if (this.storedPosition != defaultPos && isSelected && worldIn.field_72995_K) {
                    ++this.ticker;
                    for (int i = 0; i < locationsNum; ++i) {
                        float val = (float)i * 0.125f;
                        if (this.storedPositionList.size() <= i) continue;
                        this.spawnParticleAroundPedestalBase(worldIn, this.ticker, this.storedPositionList.get(i), val, val, val, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public boolean isPedestalInRange(PedestalTileEntity pedestalSender, BlockPos receiver) {
        int range = pedestalSender.getLinkingRange();
        int x = receiver.func_177958_n();
        int y = receiver.func_177956_o();
        int z = receiver.func_177952_p();
        int x1 = pedestalSender.func_174877_v().func_177958_n();
        int y1 = pedestalSender.func_174877_v().func_177956_o();
        int z1 = pedestalSender.func_174877_v().func_177952_p();
        int xF = Math.abs(Math.subtractExact(x, x1));
        int yF = Math.abs(Math.subtractExact(y, y1));
        int zF = Math.abs(Math.subtractExact(z, z1));
        return xF <= range && yF <= range && zF <= range;
    }

    @Override
    public BlockPos getStoredPosition(ItemStack getWrenchItem) {
        this.getPosFromNBT(getWrenchItem);
        return this.storedPosition;
    }

    @Override
    public List<BlockPos> getStoredPositionList(ItemStack getWrenchItem) {
        this.getPosListFromNBT(getWrenchItem);
        return this.storedPositionList;
    }

    @Override
    public void writePosToNBT(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("stored_x", this.storedPosition.func_177958_n());
        compound.func_74768_a("stored_y", this.storedPosition.func_177956_o());
        compound.func_74768_a("stored_z", this.storedPosition.func_177952_p());
        stack.func_77982_d(compound);
    }

    @Override
    public void writePosListToNBT(ItemStack stack) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        ArrayList<Integer> xval = new ArrayList<Integer>();
        ArrayList<Integer> yval = new ArrayList<Integer>();
        ArrayList<Integer> zval = new ArrayList<Integer>();
        for (int i = 0; i < this.storedPositionList.size(); ++i) {
            xval.add(i, this.storedPositionList.get(i).func_177958_n());
            yval.add(i, this.storedPositionList.get(i).func_177956_o());
            zval.add(i, this.storedPositionList.get(i).func_177952_p());
        }
        compound.func_197646_b("storedlist_x", xval);
        compound.func_197646_b("storedlist_y", yval);
        compound.func_197646_b("storedlist_z", zval);
        stack.func_77982_d(compound);
    }

    @Override
    public void getPosFromNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            int x = getCompound.func_74762_e("stored_x");
            int y = getCompound.func_74762_e("stored_y");
            int z = getCompound.func_74762_e("stored_z");
            this.storedPosition = new BlockPos(x, y, z);
        }
    }

    @Override
    public void getPosListFromNBT(ItemStack stack) {
        ArrayList<BlockPos> posStored = new ArrayList<BlockPos>();
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            int[] xval = getCompound.func_74759_k("storedlist_x");
            int[] yval = getCompound.func_74759_k("storedlist_y");
            int[] zval = getCompound.func_74759_k("storedlist_z");
            for (int i = 0; i < xval.length; ++i) {
                posStored.add(i, new BlockPos(xval[i], yval[i], zval[i]));
            }
            this.storedPositionList = posStored;
        }
    }

    @Override
    public void spawnParticleAroundPedestalBase(World world, int tick, BlockPos pos, float r, float g, float b, float alpha) {
        double dx = pos.func_177958_n();
        double dy = pos.func_177956_o();
        double dz = pos.func_177952_p();
        BlockState state = world.func_180495_p(pos);
        Direction enumfacing = Direction.UP;
        if (state.func_177230_c() instanceof PedestalBlock) {
            enumfacing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        RedstoneParticleData parti = new RedstoneParticleData(r, g, b, alpha);
        switch (enumfacing) {
            case UP: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case DOWN: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case NORTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                return;
            }
            case SOUTH: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.25, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.25, dz + 0.5, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.75, dz + 0.5, 0.0, 0.0, 0.0);
                }
                return;
            }
            case EAST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
            case WEST: {
                if (tick % 20 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.25, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 25 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.25, dz + 0.75, 0.0, 0.0, 0.0);
                }
                if (tick % 15 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.75, dz + 0.25, 0.0, 0.0, 0.0);
                }
                if (tick % 30 == 0) {
                    world.func_195594_a((IParticleData)parti, dx + 0.5, dy + 0.75, dz + 0.75, 0.0, 0.0, 0.0);
                }
                return;
            }
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 35 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.25, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
        }
        if (tick % 25 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.25, 0.0, 0.0, 0.0);
        }
        if (tick % 30 == 0) {
            world.func_195594_a((IParticleData)parti, dx + 0.75, dy + 0.5, dz + 0.75, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent selected = new TranslationTextComponent(this.func_77658_a() + ".tool_block_selected");
        TranslationTextComponent unselected = new TranslationTextComponent(this.func_77658_a() + ".tool_block_unselected");
        TranslationTextComponent cordX = new TranslationTextComponent(this.func_77658_a() + ".tool_X");
        TranslationTextComponent cordY = new TranslationTextComponent(this.func_77658_a() + ".tool_Y");
        TranslationTextComponent cordZ = new TranslationTextComponent(this.func_77658_a() + ".tool_Z");
        if (stack.func_77973_b() instanceof ItemLinkingTool) {
            if (stack.func_77942_o()) {
                if (stack.func_77948_v()) {
                    selected.func_240702_b_(cordX.getString());
                    selected.func_240702_b_("" + this.getStoredPosition(stack).func_177958_n() + "");
                    selected.func_240702_b_(cordY.getString());
                    selected.func_240702_b_("" + this.getStoredPosition(stack).func_177956_o() + "");
                    selected.func_240702_b_(cordZ.getString());
                    selected.func_240702_b_("" + this.getStoredPosition(stack).func_177952_p() + "");
                    tooltip.add((ITextComponent)selected);
                } else {
                    tooltip.add((ITextComponent)unselected);
                }
            } else {
                tooltip.add((ITextComponent)unselected);
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)DEFAULT);
    }
}

