/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class OpenGuiMessage {
    private final Operation operation;
    private final MFLocator locator;

    private OpenGuiMessage(Operation operation, MFLocator locator) {
        this.operation = operation;
        this.locator = locator;
    }

    OpenGuiMessage(PacketBuffer buf) {
        this.operation = (Operation)buf.func_179257_a(Operation.class);
        this.locator = MFLocator.fromBuffer(buf);
    }

    public static OpenGuiMessage openRouter(MFLocator locator) {
        return new OpenGuiMessage(Operation.ROUTER, locator);
    }

    public static OpenGuiMessage openModuleInHand(MFLocator locator) {
        return new OpenGuiMessage(Operation.MODULE_HELD, locator);
    }

    public static OpenGuiMessage openModuleInRouter(MFLocator locator) {
        return new OpenGuiMessage(Operation.MODULE_INSTALLED, locator);
    }

    public static OpenGuiMessage openFilterInHeldModule(MFLocator locator) {
        return new OpenGuiMessage(Operation.FILTER_HELD, locator);
    }

    public static OpenGuiMessage openFilterInInstalledModule(MFLocator locator) {
        return new OpenGuiMessage(Operation.FILTER_INSTALLED, locator);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.operation);
        this.locator.writeBuf(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                switch (this.operation) {
                    case ROUTER: {
                        this.locator.getRouter(player.func_130014_f_()).ifPresent(router -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)router, (BlockPos)this.locator.routerPos));
                        break;
                    }
                    case MODULE_HELD: {
                        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemModule.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf);
                        break;
                    }
                    case MODULE_INSTALLED: {
                        this.locator.getRouter(player.func_130014_f_()).ifPresent(router -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemModule.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf));
                        break;
                    }
                    case FILTER_HELD: {
                        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemSmartFilter.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf);
                        break;
                    }
                    case FILTER_INSTALLED: {
                        this.locator.getRouter(player.func_130014_f_()).ifPresent(router -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new ItemSmartFilter.ContainerProvider((PlayerEntity)player, this.locator), this.locator::writeBuf));
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static enum Operation {
        ROUTER,
        MODULE_HELD,
        MODULE_INSTALLED,
        FILTER_HELD,
        FILTER_INSTALLED;

    }
}

