/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.energy.CapabilityEnergy;

public class CompiledEnergyDistributorModule
extends CompiledModule {
    public CompiledEnergyDistributorModule(@Nullable TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        List inRange = this.getTargets().stream().filter(target -> target.isSameWorld(router.func_145831_w()) && router.func_174877_v().func_177951_i((Vector3i)target.gPos.func_218180_b()) <= (double)this.getRangeSquared()).collect(Collectors.toList());
        if (inRange.isEmpty()) {
            return false;
        }
        int total = router.getCapability(CapabilityEnergy.ENERGY).map(routerHandler -> {
            int toSend = routerHandler.getEnergyStored() / inRange.size();
            int total1 = 0;
            boolean doBeam = router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2;
            for (ModuleTarget target : inRange) {
                total1 += target.getEnergyHandler().map(handler -> {
                    int toExtract = routerHandler.extractEnergy(toSend, true);
                    int sent = handler.receiveEnergy(toExtract, false);
                    routerHandler.extractEnergy(sent, false);
                    if (sent > 0 && doBeam) {
                        router.addItemBeam(new BeamData(router.getTickRate(), target.gPos.func_218180_b(), 0xE04040));
                    }
                    return sent;
                }).orElse(0).intValue();
            }
            return total1;
        }).orElse(0);
        return total > 0;
    }

    @Override
    public List<ModuleTarget> setupTargets(TileEntityItemRouter router, ItemStack stack) {
        return router == null ? Collections.emptyList() : ImmutableList.copyOf(TargetedModule.getTargets(stack, !router.func_145831_w().field_72995_K));
    }
}

