/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;

public class CompiledActivatorModule
extends CompiledModule {
    public static final String NBT_ACTION_TYPE_OLD = "ActionType";
    public static final String NBT_ACTION_TYPE = "ActionType2";
    public static final String NBT_LOOK_DIRECTION = "LookDirection";
    public static final String NBT_SNEAKING = "Sneaking";
    public static final String NBT_ENTITY_MODE = "EntityMode";
    private static Set<EntityType<?>> useBlacklist = new ObjectOpenHashSet();
    private static Set<EntityType<?>> attackBlacklist = new ObjectOpenHashSet();
    private static boolean needCacheRebuild = true;
    private final ActionType actionType;
    private final LookDirection lookDirection;
    private final EntityMode entityMode;
    private final boolean sneaking;
    private int entityIdx;
    private final Set<String> BLOCK_METHODS = ImmutableSet.of((Object)"onBlockActivated", (Object)"use");
    private final Set<String> ITEM_METHODS = ImmutableSet.of((Object)"onItemUseFirst", (Object)"onItemUse", (Object)"useOn", (Object)"onItemRightClick", (Object)"use");
    private static final Set<Item> itemBlacklist = new HashSet<Item>();
    private static final Set<Block> blockBlacklist = new HashSet<Block>();

    public CompiledActivatorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null) {
            this.actionType = compound.func_74764_b(NBT_ACTION_TYPE_OLD) ? ActionType.fromOldOrdinal(compound.func_74762_e(NBT_ACTION_TYPE_OLD)) : ActionType.values()[compound.func_74762_e(NBT_ACTION_TYPE)];
            this.lookDirection = LookDirection.values()[compound.func_74762_e(NBT_LOOK_DIRECTION)];
            this.entityMode = EntityMode.values()[compound.func_74762_e(NBT_ENTITY_MODE)];
            this.sneaking = compound.func_74767_n(NBT_SNEAKING);
        } else {
            this.actionType = ActionType.ITEM_OR_BLOCK;
            this.lookDirection = LookDirection.LEVEL;
            this.entityMode = EntityMode.NEAREST;
            this.sneaking = false;
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        ItemStack stack = router.getBufferItemStack();
        if (itemBlacklist.contains(stack.func_77973_b())) {
            return false;
        }
        if (!stack.func_190926_b() && !this.getFilter().test(stack) || stack.func_190926_b() && !this.getFilter().isEmpty() && !this.getFilter().isBlacklist()) {
            return false;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        Vector3d centre = Vector3d.func_237489_a_((Vector3i)router.func_174877_v());
        fakePlayer.func_70107_b(centre.func_82615_a() + (double)this.getFacing().func_82601_c() * 0.501, centre.func_82617_b() + (double)this.getFacing().func_96559_d() * 0.501, centre.func_82616_c() + (double)this.getFacing().func_82599_e() * 0.501);
        fakePlayer.func_226284_e_(this.sneaking);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        boolean didWork = false;
        switch (this.actionType) {
            case ITEM_OR_BLOCK: {
                didWork = this.doUseItem(router, fakePlayer);
                break;
            }
            case USE_ITEM_ON_ENTITY: {
                didWork = this.doUseItemOnEntity(router, fakePlayer);
                break;
            }
            case ATTACK_ENTITY: {
                didWork = this.doAttackEntity(router, fakePlayer);
            }
        }
        if (didWork) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            this.dropExtraItems(router, (PlayerEntity)fakePlayer);
        }
        return didWork;
    }

    private boolean doUseItem(TileEntityItemRouter router, FakePlayer fakePlayer) {
        BlockPos pos = router.func_174877_v();
        World world = router.func_145831_w();
        ItemStack stack = router.getBufferItemStack();
        fakePlayer.field_70177_z = MiscUtil.getYawFromFacing(this.getFacing());
        fakePlayer.field_70125_A = this.getFacing().func_176740_k() == Direction.Axis.Y ? (float)(this.getFacing().func_96559_d() * -90) : this.lookDirection.pitch;
        BlockRayTraceResult brtr = this.doRayTrace(pos, fakePlayer);
        BlockState state = world.func_180495_p(brtr.func_216350_a());
        if (brtr.func_216346_c() != RayTraceResult.Type.MISS && blockBlacklist.contains(state.func_177230_c())) {
            return false;
        }
        try {
            return fakePlayer.field_71134_c.func_219441_a((ServerPlayerEntity)fakePlayer, world, stack, Hand.MAIN_HAND, brtr).func_226246_a_() || fakePlayer.field_71134_c.func_187250_a((ServerPlayerEntity)fakePlayer, world, stack, Hand.MAIN_HAND).func_226246_a_();
        }
        catch (Exception e) {
            this.handleBlacklisting(stack, state, e);
            return false;
        }
    }

    private void handleBlacklisting(ItemStack stack, BlockState state, Exception e) {
        for (StackTraceElement el : e.getStackTrace()) {
            if (this.ITEM_METHODS.contains(el.getMethodName())) {
                ModularRouters.LOGGER.error("Attempting to use item {} threw an exception. Blacklisting this item for the Activator Module until next server restart!", (Object)stack);
                ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
                itemBlacklist.add(stack.func_77973_b());
                return;
            }
            if (!this.BLOCK_METHODS.contains(el.getMethodName())) continue;
            ModularRouters.LOGGER.error("Attempting to use block {} threw an exception. Blacklisting this block for the Activator Module until next server restart!", (Object)state);
            ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
            blockBlacklist.add(state.func_177230_c());
            return;
        }
    }

    private BlockRayTraceResult doRayTrace(BlockPos routerPos, FakePlayer fp) {
        Vector3d fpVec = fp.func_213303_ch();
        int xOff = this.getFacing().func_82601_c();
        int yOff = this.getFacing().func_96559_d();
        int zOff = this.getFacing().func_82599_e();
        BlockPos.Mutable targetPos = routerPos.func_177972_a(this.getFacing()).func_239590_i_();
        if (this.lookDirection != LookDirection.LEVEL && Block.func_208062_a((VoxelShape)fp.field_70170_p.func_180495_p((BlockPos)targetPos).func_196954_c((IBlockReader)fp.field_70170_p, (BlockPos)targetPos))) {
            if (this.lookDirection == LookDirection.ABOVE) {
                fpVec = Vector3d.func_237489_a_((Vector3i)targetPos).func_72441_c(0.0, 1.0, 0.0);
                yOff = -1;
            } else if (this.lookDirection == LookDirection.BELOW) {
                fpVec = Vector3d.func_237489_a_((Vector3i)targetPos).func_72441_c(0.0, -1.0, 0.0);
                yOff = 1;
            }
        } else if (this.lookDirection == LookDirection.ABOVE) {
            targetPos.func_189536_c(Direction.UP);
            yOff = 1;
        } else if (this.lookDirection == LookDirection.BELOW) {
            targetPos.func_189536_c(Direction.DOWN);
            yOff = -1;
        }
        double reachDist = Math.pow(this.getPlayerReachDistance((PlayerEntity)fp), 2.0);
        while (targetPos.func_177951_i((Vector3i)routerPos) <= reachDist) {
            Vector3d targetVec;
            BlockRayTraceResult res;
            VoxelShape shape;
            if (!fp.field_70170_p.func_175623_d((BlockPos)targetPos) && !(shape = fp.field_70170_p.func_180495_p((BlockPos)targetPos).func_196954_c((IBlockReader)fp.field_70170_p, (BlockPos)targetPos)).func_197766_b() && (res = fp.field_70170_p.func_217299_a(new RayTraceContext(fpVec, targetVec = ((AxisAlignedBB)shape.func_197756_d().get(0)).func_189972_c().func_178787_e(Vector3d.func_237491_b_((Vector3i)targetPos)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, null))).func_216346_c() == RayTraceResult.Type.BLOCK) {
                return res;
            }
            targetPos.func_196234_d(xOff, yOff, zOff);
        }
        return BlockRayTraceResult.func_216352_a((Vector3d)fpVec.func_178787_e(fp.func_70040_Z()), (Direction)this.getFacing().func_176734_d(), (BlockPos)routerPos.func_177972_a(this.getFacing()));
    }

    private double getPlayerReachDistance(PlayerEntity player) {
        ModifiableAttributeInstance attr;
        if (player != null && (attr = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            return attr.func_111126_e() + 1.0;
        }
        return 4.5;
    }

    private boolean doAttackEntity(TileEntityItemRouter router, RouterFakePlayer fakePlayer) {
        LivingEntity entity = this.findEntity(router, LivingEntity.class, this::passesAttackBlacklist);
        if (entity == null || entity instanceof PlayerEntity && router.getUpgradeCount((Item)ModItems.SECURITY_UPGRADE.get()) > 0 && router.isPermitted((PlayerEntity)entity)) {
            return false;
        }
        fakePlayer.func_200602_a(EntityAnchorArgument.Type.EYES, entity.func_213303_ch());
        fakePlayer.func_71059_n((Entity)entity);
        return true;
    }

    private boolean doUseItemOnEntity(TileEntityItemRouter router, FakePlayer fakePlayer) {
        Entity entity = this.findEntity(router, Entity.class, this::passesUseBlacklist);
        if (entity == null) {
            return false;
        }
        ActionResultType result = fakePlayer.func_190775_a(entity, Hand.MAIN_HAND);
        if (result.func_226246_a_()) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private <T extends Entity> T findEntity(TileEntityItemRouter router, Class<T> cls, Predicate<Entity> blacklistChecker) {
        Direction face = this.getFacing();
        BlockPos pos = router.func_174877_v();
        Vector3d vec = Vector3d.func_237489_a_((Vector3i)pos);
        AxisAlignedBB box = new AxisAlignedBB(vec, vec).func_72317_d((double)face.func_82601_c() * 2.5, (double)face.func_96559_d() * 2.5, (double)face.func_82599_e() * 2.5).func_186662_g(2.0);
        List l = router.func_145831_w().func_175647_a(cls, box, blacklistChecker);
        if (l.isEmpty()) {
            return null;
        }
        switch (this.entityMode) {
            case RANDOM: {
                return (T)((Entity)l.get(router.func_145831_w().field_73012_v.nextInt(l.size())));
            }
            case NEAREST: {
                l.sort(Comparator.comparingDouble(o -> o.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                return (T)((Entity)l.get(0));
            }
            case ROUND_ROBIN: {
                l.sort(Comparator.comparingDouble(o -> o.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                this.entityIdx = (this.entityIdx + 1) % l.size();
                return (T)((Entity)l.get(this.entityIdx));
            }
        }
        return null;
    }

    private boolean passesAttackBlacklist(Entity e) {
        if (needCacheRebuild) {
            CompiledActivatorModule.rebuildBlacklists();
        }
        return !attackBlacklist.contains(e.func_200600_R());
    }

    private boolean passesUseBlacklist(Entity e) {
        if (needCacheRebuild) {
            CompiledActivatorModule.rebuildBlacklists();
        }
        return !useBlacklist.contains(e.func_200600_R());
    }

    public static void clearBlacklistCache() {
        needCacheRebuild = true;
    }

    private static void rebuildBlacklists() {
        useBlacklist = CompiledActivatorModule.processBlacklist(MRConfig.Common.Module.activatorEntityBlacklist, "activatorEntityBlacklist");
        attackBlacklist = CompiledActivatorModule.processBlacklist(MRConfig.Common.Module.activatorEntityAttackBlacklist, "activatorEntityAttackBlacklist");
        needCacheRebuild = false;
    }

    private static Set<EntityType<?>> processBlacklist(Set<String> strings, String what) {
        ObjectOpenHashSet res = new ObjectOpenHashSet();
        for (String id : strings) {
            if (id.startsWith("#")) {
                ITag tag = EntityTypeTags.func_219762_a().func_199910_a(new ResourceLocation(id.substring(1)));
                if (tag != null) {
                    res.addAll(tag.func_230236_b_());
                    continue;
                }
                ModularRouters.LOGGER.warn(String.format("unknown entity type tag '%s' in modularrouters-common.toml / %s", id, what));
                continue;
            }
            ResourceLocation rl = new ResourceLocation(id);
            if (ForgeRegistries.ENTITIES.containsKey(rl)) {
                res.add(ForgeRegistries.ENTITIES.getValue(rl));
                continue;
            }
            ModularRouters.LOGGER.warn(String.format("unknown entity type '%s' in modularrouters-common.toml / %s", id, what));
        }
        return res;
    }

    private void dropExtraItems(TileEntityItemRouter router, PlayerEntity fakePlayer) {
        NonNullList inv = fakePlayer.field_71071_by.field_70462_a;
        Vector3d where = Vector3d.func_237489_a_((Vector3i)router.func_174877_v().func_177972_a(this.getFacing()));
        for (int i = 1; i < inv.size() && !((ItemStack)inv.get(i)).func_190926_b(); ++i) {
            ItemEntity item = new ItemEntity(router.func_145831_w(), where.func_82615_a(), where.func_82617_b(), where.func_82616_c(), (ItemStack)inv.get(i));
            router.func_145831_w().func_217376_c((Entity)item);
            inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LookDirection getLookDirection() {
        return this.lookDirection;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public int getEnergyCost() {
        return this.actionType == ActionType.ATTACK_ENTITY ? MRConfig.Common.EnergyCosts.activatorModuleEnergyCostAttack : MRConfig.Common.EnergyCosts.activatorModuleEnergyCost;
    }

    @Override
    public boolean careAboutItemAttributes() {
        return this.actionType == ActionType.ATTACK_ENTITY;
    }

    public static enum EntityMode implements IHasTranslationKey
    {
        NEAREST,
        RANDOM,
        ROUND_ROBIN;


        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.entityMode." + this;
        }
    }

    public static enum LookDirection implements IHasTranslationKey
    {
        LEVEL(0.0f),
        ABOVE(-45.0f),
        BELOW(45.0f);

        private final float pitch;

        private LookDirection(float pitch) {
            this.pitch = pitch;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.direction." + this;
        }
    }

    public static enum ActionType implements IHasTranslationKey
    {
        ITEM_OR_BLOCK(false),
        USE_ITEM_ON_ENTITY(true),
        ATTACK_ENTITY(true);

        private final boolean entity;

        private ActionType(boolean entity) {
            this.entity = entity;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.action." + this;
        }

        public static ActionType fromOldOrdinal(int ord) {
            return ord == 2 ? USE_ITEM_ON_ENTITY : ITEM_OR_BLOCK;
        }

        public boolean isEntityTarget() {
            return this.entity;
        }
    }
}

