/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import java.util.Objects;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleTarget {
    public final GlobalPos gPos;
    public final Direction face;
    public final String blockTranslationKey;
    private LazyOptional<IItemHandler> cachedItemCap = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> cachedEnergyCap = LazyOptional.empty();

    public ModuleTarget(GlobalPos gPos, Direction face, String blockTranslationKey) {
        this.gPos = gPos;
        this.face = face;
        this.blockTranslationKey = blockTranslationKey;
    }

    public ModuleTarget(GlobalPos gPos, Direction face) {
        this(gPos, face, "");
    }

    public ModuleTarget(GlobalPos gPos) {
        this(gPos, null);
    }

    public CompoundNBT toNBT() {
        CompoundNBT ext = new CompoundNBT();
        ext.func_218657_a("Pos", (INBT)MiscUtil.serializeGlobalPos(this.gPos));
        ext.func_74774_a("Face", (byte)this.face.ordinal());
        ext.func_74778_a("InvName", this.blockTranslationKey);
        return ext;
    }

    public static ModuleTarget fromNBT(CompoundNBT nbt) {
        GlobalPos gPos = MiscUtil.deserializeGlobalPos(nbt.func_74775_l("Pos"));
        Direction face = Direction.values()[nbt.func_74771_c("Face")];
        return new ModuleTarget(gPos, face, nbt.func_74779_i("InvName"));
    }

    public boolean isSameWorld(World world) {
        return this.gPos.func_239646_a_() == world.func_234923_W_();
    }

    public boolean isSameWorld(ModuleTarget dst) {
        return this.gPos.func_239646_a_() == dst.gPos.func_239646_a_();
    }

    public boolean hasItemHandlerClientSide() {
        World w = ClientUtil.theClientWorld();
        return this.isSameWorld(w) && this.getItemHandlerFor(w).isPresent();
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.getItemHandlerFor((World)MiscUtil.getWorldForGlobalPos(this.gPos));
    }

    private LazyOptional<IItemHandler> getItemHandlerFor(World w) {
        if (!this.cachedItemCap.isPresent()) {
            BlockPos pos = this.gPos.func_218180_b();
            if (w == null || !w.func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
                this.cachedItemCap = LazyOptional.empty();
            } else {
                TileEntity te = w.func_175625_s(pos);
                LazyOptional lazyOptional = this.cachedItemCap = te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face);
            }
            if (this.cachedItemCap.isPresent()) {
                this.cachedItemCap.addListener(c -> {
                    this.cachedItemCap = LazyOptional.empty();
                });
            }
        }
        return this.cachedItemCap;
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        if (!this.cachedEnergyCap.isPresent()) {
            BlockPos pos = this.gPos.func_218180_b();
            ServerWorld w = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (w == null || !w.func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
                this.cachedEnergyCap = LazyOptional.empty();
            } else {
                TileEntity te = w.func_175625_s(pos);
                LazyOptional lazyOptional = this.cachedEnergyCap = te == null ? LazyOptional.empty() : te.getCapability(CapabilityEnergy.ENERGY, this.face);
            }
            if (this.cachedEnergyCap.isPresent()) {
                this.cachedEnergyCap.addListener(c -> {
                    this.cachedEnergyCap = LazyOptional.empty();
                });
            }
        }
        return this.cachedEnergyCap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleTarget)) {
            return false;
        }
        ModuleTarget that = (ModuleTarget)o;
        return this.gPos.equals((Object)that.gPos) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.gPos, this.face);
    }

    public String toString() {
        return MiscUtil.locToString(this.gPos) + " " + this.face;
    }

    public ITextComponent getTextComponent() {
        return new TranslationTextComponent(this.blockTranslationKey).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new StringTextComponent(" @ " + this.toString()).func_240699_a_(TextFormatting.AQUA));
    }
}

