/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CamouflageUpgrade
extends ItemUpgrade {
    public static final String NBT_STATE_NAME = "BlockStateName";

    @Override
    public void onCompiled(ItemStack stack, TileEntityItemRouter router) {
        super.onCompiled(stack, router);
        router.setCamouflage(CamouflageUpgrade.getCamoState(stack));
    }

    private static void setCamoState(ItemStack stack, BlockState camoState) {
        stack.func_190925_c("modularrouters").func_218657_a(NBT_STATE_NAME, (INBT)NBTUtil.func_190009_a((BlockState)camoState));
    }

    private static BlockState getCamoState(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("modularrouters");
        return tag != null ? NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l(NBT_STATE_NAME)) : null;
    }

    private static ITextComponent getCamoStateDisplayName(ItemStack stack) {
        BlockState state = CamouflageUpgrade.getCamoState(stack);
        return state != null ? CamouflageUpgrade.getCamoStateDisplayName(state) : new StringTextComponent("<?>");
    }

    private static ITextComponent getCamoStateDisplayName(BlockState camoState) {
        return new ItemStack((IItemProvider)camoState.func_177230_c().func_199767_j()).func_200301_q();
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        assert (player != null);
        ItemStack stack = ctx.func_195996_i();
        BlockState state = ctx.func_195991_k().func_180495_p(ctx.func_195995_a());
        if (CamouflageUpgrade.isBlockOKForCamo(state)) {
            CamouflageUpgrade.setCamoState(stack, state);
            if (!ctx.func_195991_k().field_72995_K) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("modularrouters.itemText.camouflage.held").func_240702_b_(TextFormatting.AQUA.toString()).func_230529_a_(CamouflageUpgrade.getCamoStateDisplayName(stack)).func_240699_a_(TextFormatting.YELLOW), true);
            } else {
                player.func_184185_a((SoundEvent)ModSounds.SUCCESS.get(), 1.0f, 1.5f);
            }
            return ActionResultType.SUCCESS;
        }
        if (ctx.func_195991_k().field_72995_K) {
            player.func_184185_a((SoundEvent)ModSounds.ERROR.get(), 1.0f, 1.0f);
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        BlockState camoState = CamouflageUpgrade.getCamoState(stack);
        ITextComponent disp = super.func_200295_i(stack);
        if (camoState != null) {
            return disp.func_230532_e_().func_240702_b_(": ").func_230529_a_(CamouflageUpgrade.getCamoStateDisplayName(camoState)).func_240699_a_(TextFormatting.YELLOW);
        }
        return disp;
    }

    private static boolean isBlockOKForCamo(BlockState state) {
        return state.func_185901_i() == BlockRenderType.MODEL && state.func_177230_c() != ModBlocks.ITEM_ROUTER.get() && !state.func_177230_c().getRegistryName().func_110624_b().equals("chiselsandbits");
    }
}

