/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.area;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import me.desht.modularrouters.client.render.ModRenderTypes;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;

public class AreaRenderer {
    private final Set<BlockPos> showingPositions;
    private final int[] cols;
    private final float size;

    AreaRenderer(Set<BlockPos> area, int color, float size) {
        this.showingPositions = area;
        this.cols = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        this.size = size;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer.Impl buffer) {
        this.render(matrixStack, buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_FACE));
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(ModRenderTypes.BLOCK_HILIGHT_FACE);
        this.render(matrixStack, buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_LINE));
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(ModRenderTypes.BLOCK_HILIGHT_LINE);
    }

    private void render(MatrixStack matrixStack, IVertexBuilder builder) {
        for (BlockPos pos : this.showingPositions) {
            matrixStack.func_227860_a_();
            double start = (double)(1.0f - this.size) / 2.0;
            matrixStack.func_227861_a_((double)pos.func_177958_n() + start, (double)pos.func_177956_o() + start, (double)pos.func_177952_p() + start);
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            this.addVertices(builder, posMat);
            matrixStack.func_227865_b_();
        }
    }

    private void addVertices(IVertexBuilder wr, Matrix4f posMat) {
        wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, this.size, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, this.size, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, 0.0f, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, 0.0f, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, this.size, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, this.size, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, 0.0f, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, 0.0f, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, this.size, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, this.size, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, this.size, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, this.size, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, 0.0f, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, 0.0f, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, 0.0f, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, 0.0f, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, 0.0f, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, this.size, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, this.size, this.size).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, this.size, this.size, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, this.size, 0.0f).func_225586_a_(this.cols[1], this.cols[2], this.cols[3], this.cols[0]).func_181675_d();
    }
}

