/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule1;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.Range;

public class GuiModuleFluid
extends GuiModule {
    private static final ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_151133_ar);
    private static final ItemStack routerStack = new ItemStack((IItemProvider)ModBlocks.ITEM_ROUTER.get());
    private static final ItemStack waterStack = new ItemStack((IItemProvider)Items.field_151131_as);
    private ForceEmptyButton forceEmptyButton;
    private RegulateAbsoluteButton regulationTypeButton;
    private FluidDirectionButton fluidDirButton;
    private IntegerTextField maxTransferField;

    public GuiModuleFluid(ContainerModule container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        CompiledFluidModule1 cfm = new CompiledFluidModule1(null, this.moduleItemStack);
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        int max = MRConfig.Common.Router.baseTickRate * MRConfig.Common.Router.fluidMaxTransferRate;
        this.maxTransferField = new IntegerTextField(manager, this.field_230712_o_, this.field_147003_i + 152, this.field_147009_r + 23, 34, 12, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(max)));
        this.maxTransferField.setValue(cfm.getMaxTransfer());
        this.maxTransferField.func_212954_a(str -> this.sendModuleSettingsDelayed(5));
        this.maxTransferField.setIncr(100, 10, 10);
        this.maxTransferField.useGuiTextBackground();
        manager.focus(0);
        this.func_230480_a_((Widget)new TooltipButton(this.field_147003_i + 130, this.field_147009_r + 19, 16, 16, bucketStack));
        this.fluidDirButton = new FluidDirectionButton(this.field_147003_i + 148, this.field_147009_r + 44, cfm.getFluidDirection());
        this.func_230480_a_((Widget)this.fluidDirButton);
        this.forceEmptyButton = new ForceEmptyButton(this.field_147003_i + 168, this.field_147009_r + 69, cfm.isForceEmpty());
        this.func_230480_a_((Widget)this.forceEmptyButton);
        this.regulationTypeButton = new RegulateAbsoluteButton(this.regulatorTextField.field_230690_l_ + this.regulatorTextField.func_230998_h_() + 2, this.regulatorTextField.field_230691_m_ - 1, 18, 14, b -> this.toggleRegulationType(), cfm.isRegulateAbsolute());
        this.func_230480_a_((Widget)this.regulationTypeButton);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 17, this.field_147003_i + 183, this.field_147009_r + 35, "modularrouters.guiText.popup.fluid.maxTransfer");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 126, this.field_147009_r + 42, this.field_147003_i + 185, this.field_147009_r + 61, "modularrouters.guiText.popup.fluid.direction");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 67, this.field_147003_i + 185, this.field_147009_r + 86, "modularrouters.guiText.popup.fluid.forceEmpty");
    }

    @Override
    protected IntegerTextField buildRegulationTextField(TextFieldManager manager) {
        IntegerTextField tf = new IntegerTextField(manager, this.field_230712_o_, this.field_147003_i + 128, this.field_147009_r + 90, 40, 12, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        tf.setValue(this.getRegulatorAmount());
        tf.func_212954_a(str -> {
            this.setRegulatorAmount(str.isEmpty() ? 0 : Integer.parseInt(str));
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.func_238474_b_(matrixStack, this.field_147003_i + 146, this.field_147009_r + 20, GuiModuleFluid.LARGE_TEXTFIELD_XY.x, GuiModuleFluid.LARGE_TEXTFIELD_XY.y, 35, 14);
        GuiUtil.renderItemStack(matrixStack, this.field_230706_i_, routerStack, this.field_147003_i + 128, this.field_147009_r + 44, "");
        GuiUtil.renderItemStack(matrixStack, this.field_230706_i_, waterStack, this.field_147003_i + 168, this.field_147009_r + 44, "");
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        if (this.forceEmptyButton.field_230694_p_) {
            String s = I18n.func_135052_a((String)"modularrouters.guiText.label.fluidForceEmpty", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(165 - this.field_230712_o_.func_78256_a(s)), 73.0f, 0x202040);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.regulationTypeButton.field_230694_p_ = this.regulatorTextField.field_230694_p_;
        this.regulationTypeButton.setText();
        this.regulatorTextField.setRange((Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.regulationTypeButton.regulateAbsolute ? Integer.MAX_VALUE : 100)));
        this.forceEmptyButton.field_230694_p_ = this.fluidDirButton.getState() == FluidModule1.FluidDirection.OUT;
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT compound = super.buildMessageData();
        compound.func_74768_a("MaxTransfer", this.maxTransferField.getIntValue());
        compound.func_74774_a("FluidDir", (byte)((FluidModule1.FluidDirection)this.fluidDirButton.getState()).ordinal());
        compound.func_74757_a("ForceEmpty", this.forceEmptyButton.isToggled());
        compound.func_74757_a("RegulateAbsolute", this.regulationTypeButton.regulateAbsolute);
        return compound;
    }

    private void toggleRegulationType() {
        this.regulationTypeButton.toggle();
        this.regulatorTextField.setRange((Range<Integer>)(this.regulationTypeButton.regulateAbsolute ? Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100))));
        this.sendToServer();
    }

    private static class RegulateAbsoluteButton
    extends ExtendedButton {
        private boolean regulateAbsolute;

        public RegulateAbsoluteButton(int xPos, int yPos, int width, int height, Button.IPressable pressable, boolean regulateAbsolute) {
            super(xPos, yPos, width, height, StringTextComponent.field_240750_d_, pressable);
            this.regulateAbsolute = regulateAbsolute;
        }

        private void toggle() {
            this.regulateAbsolute = !this.regulateAbsolute;
        }

        void setText() {
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.regulateAbsolute ? "mB" : "%"));
        }
    }

    private class ForceEmptyButton
    extends TexturedToggleButton {
        ForceEmptyButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleFluid.this);
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.guiText.tooltip.fluidForceEmpty.false", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, TextFormatting.WHITE, "modularrouters.guiText.tooltip.fluidForceEmpty.true", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class FluidDirectionButton
    extends TexturedCyclerButton<FluidModule1.FluidDirection> {
        private final List<List<ITextComponent>> tooltips;

        FluidDirectionButton(int x, int y, FluidModule1.FluidDirection initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleFluid.this);
            this.tooltips = Lists.newArrayList();
            for (FluidModule1.FluidDirection dir : FluidModule1.FluidDirection.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(dir.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((FluidModule1.FluidDirection)this.getState()).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(((FluidModule1.FluidDirection)this.getState()).ordinal());
        }
    }

    private class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.guiText.tooltip.fluidTransferTooltip", new Object[0]);
            this.tooltip1.add(StringTextComponent.field_240750_d_.func_230531_f_());
            GuiModuleFluid.this.getItemRouter().ifPresent(router -> {
                int ftRate = router.getFluidTransferRate();
                int tickRate = router.getTickRate();
                this.tooltip1.add(ClientUtil.xlate("modularrouters.guiText.tooltip.maxFluidPerOp", ftRate * tickRate, tickRate, ftRate));
                this.tooltip1.add(StringTextComponent.field_240750_d_.func_230531_f_());
            });
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void func_230988_a_(SoundHandler soundHandlerIn) {
        }
    }
}

