/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class MaxHealthHandler {
    private static final boolean HAS_FIRST_AID = ModList.get().isLoaded("firstaid");
    private static final UUID MILESTONE_HEALTH_MODIFIER_ID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MaxHealthHandler.updateFoodHPModifier(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(event.getOriginal());
        if (prevModifier == null) {
            return;
        }
        MaxHealthHandler.updateHealthModifier(event.getPlayer(), prevModifier);
    }

    public static boolean updateFoodHPModifier(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(player);
        int healthPenalty = 2 * (SOLCarrotConfig.getBaseHearts() - 10);
        ProgressInfo progressInfo = FoodList.get(player).getProgressInfo();
        int milestonesAchieved = progressInfo.milestonesAchieved();
        int addedHealthFromFood = milestonesAchieved * 2 * SOLCarrotConfig.getHeartsPerMilestone();
        double totalHealthModifier = healthPenalty + addedHealthFromFood;
        boolean hasChanged = prevModifier == null || prevModifier.func_111164_d() != totalHealthModifier;
        AttributeModifier modifier = new AttributeModifier(MILESTONE_HEALTH_MODIFIER_ID, "Health Gained from Trying New Foods", totalHealthModifier, AttributeModifier.Operation.ADDITION);
        MaxHealthHandler.updateHealthModifier(player, modifier);
        return hasChanged;
    }

    @Nullable
    private static AttributeModifier getHealthModifier(PlayerEntity player) {
        return MaxHealthHandler.maxHealthAttribute(player).func_111127_a(MILESTONE_HEALTH_MODIFIER_ID);
    }

    private static void updateHealthModifier(PlayerEntity player, AttributeModifier modifier) {
        float oldMax = player.func_110138_aP();
        ModifiableAttributeInstance attribute = MaxHealthHandler.maxHealthAttribute(player);
        attribute.func_111124_b(modifier);
        attribute.func_233769_c_(modifier);
        float newHealth = player.func_110143_aJ() * player.func_110138_aP() / oldMax;
        if (!HAS_FIRST_AID) {
            player.func_70606_j(1.0f);
        }
        player.func_70606_j(newHealth);
    }

    private static ModifiableAttributeInstance maxHealthAttribute(PlayerEntity player) {
        return Objects.requireNonNull(player.func_110148_a(Attributes.field_233818_a_));
    }

    private MaxHealthHandler() {
    }
}

