/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.api.SOLCarrotAPI;
import com.cazsius.solcarrot.tracking.FoodInstance;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

@ParametersAreNonnullByDefault
public final class FoodList
implements FoodCapability {
    private static final String NBT_KEY_FOOD_LIST = "foodList";
    private final Set<FoodInstance> foods = new HashSet<FoodInstance>();
    @Nullable
    private ProgressInfo cachedProgressInfo;
    private final LazyOptional<FoodList> capabilityOptional = LazyOptional.of(() -> this);

    public static FoodList get(PlayerEntity player) {
        return (FoodList)player.getCapability(SOLCarrotAPI.foodCapability).orElseThrow(FoodListNotFoundException::new);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        return capability == SOLCarrotAPI.foodCapability ? this.capabilityOptional.cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        this.foods.stream().map(FoodInstance::encode).filter(Objects::nonNull).map(StringNBT::func_229705_a_).forEach(arg_0 -> list.add(arg_0));
        tag.func_218657_a(NBT_KEY_FOOD_LIST, (INBT)list);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        ListNBT list = tag.func_150295_c(NBT_KEY_FOOD_LIST, 8);
        this.foods.clear();
        list.stream().map(nbt -> (StringNBT)nbt).map(StringNBT::func_150285_a_).map(FoodInstance::decode).filter(Objects::nonNull).forEach(this.foods::add);
        this.invalidateProgressInfo();
    }

    public boolean addFood(Item food) {
        boolean wasAdded = this.foods.add(new FoodInstance(food)) && SOLCarrotConfig.shouldCount(food);
        this.invalidateProgressInfo();
        return wasAdded;
    }

    @Override
    public boolean hasEaten(Item food) {
        if (!food.func_219971_r()) {
            return false;
        }
        return this.foods.contains(new FoodInstance(food));
    }

    public void clearFood() {
        this.foods.clear();
        this.invalidateProgressInfo();
    }

    public Set<FoodInstance> getEatenFoods() {
        return new HashSet<FoodInstance>(this.foods);
    }

    @Override
    public int getEatenFoodCount() {
        return this.foods.size();
    }

    public ProgressInfo getProgressInfo() {
        if (this.cachedProgressInfo == null) {
            this.cachedProgressInfo = new ProgressInfo(this);
        }
        return this.cachedProgressInfo;
    }

    public void invalidateProgressInfo() {
        this.cachedProgressInfo = null;
    }

    public static class FoodListNotFoundException
    extends RuntimeException {
        public FoodListNotFoundException() {
            super("Player must have food capability attached, but none was found.");
        }
    }

    public static final class Storage
    implements Capability.IStorage<FoodCapability> {
        public INBT writeNBT(Capability<FoodCapability> capability, FoodCapability instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<FoodCapability> capability, FoodCapability instance, Direction side, INBT tag) {
            instance.deserializeNBT((INBT)((CompoundNBT)tag));
        }
    }
}

