/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature;

import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.world.feature.SourceFeature;
import sirttas.elementalcraft.world.feature.config.ElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.config.RandomElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.placement.ECPlacements;
import sirttas.elementalcraft.world.feature.structure.ECStructures;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECFeatures {
    @ObjectHolder(value="elementalcraft:source")
    public static final Feature<IElementTypeFeatureConfig> SOURCE = null;
    private static ConfiguredFeature<?, ?> crystalOreConfig;
    private static ConfiguredFeature<?, ?> sourceConfig;
    private static ConfiguredFeature<?, ?> icySourceConfig;
    private static ConfiguredFeature<?, ?> jungleSourceConfig;
    private static ConfiguredFeature<?, ?> mushroomSourceConfig;
    private static ConfiguredFeature<?, ?> netherSourceConfig;
    private static ConfiguredFeature<?, ?> wetSourceConfig;
    private static ConfiguredFeature<?, ?> drySourceConfig;
    private static ConfiguredFeature<?, ?> endSourceConfig;
    private static ConfiguredFeature<?, ?> forestSourceConfig;
    private static ConfiguredFeature<?, ?> hillSourceConfig;
    private static ConfiguredFeature<?, ?> plainSourceConfig;
    private static ConfiguredFeature<?, ?> oceanSourceConfig;
    private static ConfiguredFeature<?, ?> spawnFireSourceConfig;
    private static ConfiguredFeature<?, ?> spawnWaterSourceConfig;
    private static ConfiguredFeature<?, ?> spawnEarthSourceConfig;
    private static ConfiguredFeature<?, ?> spawnAirSourceConfig;
    private static StructureFeature<?, ?> sourceAltar;

    private ECFeatures() {
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        SourceFeature source = new SourceFeature();
        ConfiguredPlacement sourcePlacement = (ConfiguredPlacement)ECPlacements.SOURCE.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a();
        ConfiguredPlacement chanceSourcePlacement = (ConfiguredPlacement)sourcePlacement.func_242729_a(((Integer)ECConfig.COMMON.sourceSpawnChance.get()).intValue());
        RegistryHelper.register(r, source, "source");
        crystalOreConfig = ECFeatures.register("crystal_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ECBlocks.CRYSTAL_ORE.func_176223_P(), ((Integer)ECConfig.COMMON.inertCrystalSize.get()).intValue())).func_242733_d(((Integer)ECConfig.COMMON.inertCrystalYMax.get()).intValue())).func_242728_a()).func_242731_b(((Integer)ECConfig.COMMON.inertCrystalCount.get()).intValue()));
        sourceConfig = ECFeatures.register("source", source.func_225566_b_(RandomElementTypeFeatureConfig.ALL).func_227228_a_((ConfiguredPlacement)sourcePlacement.func_242729_a(((Integer)ECConfig.COMMON.randomSourceSpawnChance.get()).intValue())));
        icySourceConfig = ECFeatures.register("source_icy", source.func_225566_b_(RandomElementTypeFeatureConfig.ICY).func_227228_a_(chanceSourcePlacement));
        jungleSourceConfig = ECFeatures.register("source_jungle", source.func_225566_b_(RandomElementTypeFeatureConfig.JUNGLE).func_227228_a_(chanceSourcePlacement));
        mushroomSourceConfig = ECFeatures.register("source_mushroom", source.func_225566_b_(RandomElementTypeFeatureConfig.ALL).func_227228_a_(chanceSourcePlacement));
        wetSourceConfig = ECFeatures.register("source_wet", source.func_225566_b_(RandomElementTypeFeatureConfig.WET).func_227228_a_(chanceSourcePlacement));
        drySourceConfig = ECFeatures.register("source_dry", source.func_225566_b_(RandomElementTypeFeatureConfig.DRY).func_227228_a_(chanceSourcePlacement));
        endSourceConfig = ECFeatures.register("source_end", source.func_225566_b_(RandomElementTypeFeatureConfig.END).func_227228_a_(chanceSourcePlacement));
        forestSourceConfig = ECFeatures.register("source_forest", source.func_225566_b_(RandomElementTypeFeatureConfig.FOREST).func_227228_a_(chanceSourcePlacement));
        hillSourceConfig = ECFeatures.register("source_hill", source.func_225566_b_(RandomElementTypeFeatureConfig.HILL).func_227228_a_(chanceSourcePlacement));
        plainSourceConfig = ECFeatures.register("source_plain", source.func_225566_b_(RandomElementTypeFeatureConfig.PLAIN).func_227228_a_(chanceSourcePlacement));
        netherSourceConfig = ECFeatures.register("source_nether", source.func_225566_b_(RandomElementTypeFeatureConfig.NETHER).func_227228_a_(chanceSourcePlacement));
        oceanSourceConfig = ECFeatures.register("source_ocean", source.func_225566_b_(ElementTypeFeatureConfig.WATER).func_227228_a_((ConfiguredPlacement)sourcePlacement.func_242729_a(((Integer)ECConfig.COMMON.oceanSourceSpawnChance.get()).intValue())));
        spawnFireSourceConfig = ECFeatures.register("source_fire_spawn", source.func_225566_b_(ElementTypeFeatureConfig.FIRE).func_227228_a_(sourcePlacement));
        spawnWaterSourceConfig = ECFeatures.register("source_water_spawn", source.func_225566_b_(ElementTypeFeatureConfig.WATER).func_227228_a_(sourcePlacement));
        spawnEarthSourceConfig = ECFeatures.register("source_earth_spawn", source.func_225566_b_(ElementTypeFeatureConfig.EARTH).func_227228_a_(sourcePlacement));
        spawnAirSourceConfig = ECFeatures.register("source_air_spawn", source.func_225566_b_(ElementTypeFeatureConfig.AIR).func_227228_a_(sourcePlacement));
        sourceAltar = ECFeatures.registerStructure("source_altar", ECStructures.SOURCE_ALTAR, RandomElementTypeFeatureConfig.ALL, ECStructures.SOURCE_ALTAR_PIECE_TYPE);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        boolean sourceSpawn = Boolean.FALSE.equals(ECConfig.COMMON.disableSourceSpawn.get());
        if (Boolean.FALSE.equals(ECConfig.COMMON.disableWorldGen.get())) {
            if (sourceSpawn) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, sourceConfig);
            }
            if (category != Biome.Category.THEEND && category != Biome.Category.NETHER) {
                if (Boolean.FALSE.equals(ECConfig.COMMON.disableInertCrystal.get())) {
                    event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, crystalOreConfig);
                }
                if (category != Biome.Category.BEACH && category != Biome.Category.OCEAN && category != Biome.Category.RIVER && category != Biome.Category.SWAMP) {
                    event.getGeneration().func_242516_a(sourceAltar);
                }
            }
            if (sourceSpawn) {
                switch (category) {
                    case ICY: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, icySourceConfig);
                        break;
                    }
                    case JUNGLE: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, jungleSourceConfig);
                        break;
                    }
                    case MUSHROOM: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, mushroomSourceConfig);
                        break;
                    }
                    case NETHER: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, netherSourceConfig);
                        break;
                    }
                    case OCEAN: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, oceanSourceConfig);
                        break;
                    }
                    case EXTREME_HILLS: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, hillSourceConfig);
                        break;
                    }
                    case PLAINS: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, plainSourceConfig);
                        break;
                    }
                    case BEACH: 
                    case RIVER: 
                    case SWAMP: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, wetSourceConfig);
                        break;
                    }
                    case TAIGA: 
                    case FOREST: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, forestSourceConfig);
                        break;
                    }
                    case MESA: 
                    case DESERT: 
                    case SAVANNA: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, drySourceConfig);
                        break;
                    }
                    case THEEND: {
                        event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, endSourceConfig);
                        break;
                    }
                }
            }
        }
    }

    public static void addSpawnSources(ServerWorld world) {
        if (Boolean.FALSE.equals(ECConfig.COMMON.disableSourceSpawn.get())) {
            Random rand = new Random(world.func_72905_C());
            BlockPos pos = world.func_241135_u_().func_177982_a(-100, 0, -100);
            ECFeatures.addSpawnSource(world, rand, pos.func_177982_a(rand.nextInt(100), 0, rand.nextInt(100)), spawnFireSourceConfig);
            ECFeatures.addSpawnSource(world, rand, pos.func_177982_a(rand.nextInt(100), 0, rand.nextInt(100)), spawnWaterSourceConfig);
            ECFeatures.addSpawnSource(world, rand, pos.func_177982_a(rand.nextInt(100), 0, rand.nextInt(100)), spawnEarthSourceConfig);
            ECFeatures.addSpawnSource(world, rand, pos.func_177982_a(rand.nextInt(100), 0, rand.nextInt(100)), spawnAirSourceConfig);
        }
    }

    private static void addSpawnSource(ServerWorld world, Random rand, BlockPos pos, ConfiguredFeature<?, ?> source) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ServerChunkProvider chunkProvider = world.func_72863_F();
        chunkProvider.func_217205_a(chunkPos.field_77276_a, chunkPos.field_77275_b, true);
        source.func_242765_a((ISeedReader)world, chunkProvider.func_201711_g(), rand, pos);
    }

    private static <C extends IFeatureConfig> ConfiguredFeature<C, ?> register(String name, ConfiguredFeature<C, ?> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ElementalCraft.createRL(name), feature);
    }

    private static <C extends IFeatureConfig> StructureFeature<C, ?> registerStructure(String name, Structure<C> structure, C config, IStructurePieceType structurePieceType) {
        ResourceLocation location = ElementalCraft.createRL(name);
        StructureFeature structureFeature = (StructureFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)location, (Object)new StructureFeature(structure, config));
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)location, (Object)structurePieceType);
        Structure.field_236365_a_.put((Object)structure.func_143025_a(), structure);
        return structureFeature;
    }
}

