/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.spell.AbstractSpellInstance;
import sirttas.elementalcraft.spell.SpellTickManager;
import sirttas.elementalcraft.spell.properties.SpellProperties;

public class Spell
extends ForgeRegistryEntry<Spell>
implements IElementTypeProvider {
    public static final IForgeRegistry<Spell> REGISTRY = RegistryManager.ACTIVE.getRegistry(Spell.class);
    private String translationKey;
    protected SpellProperties properties = SpellProperties.NONE;

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"spell", (ResourceLocation)REGISTRY.getKey((IForgeRegistryEntry)this));
        }
        return this.translationKey;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public Multimap<Attribute, AttributeModifier> getOnUseAttributeModifiers() {
        return this.properties.getAttributes();
    }

    public ActionResultType castOnEntity(Entity sender, Entity target) {
        return ActionResultType.PASS;
    }

    public ActionResultType castOnBlock(Entity sender, BlockPos target) {
        return ActionResultType.PASS;
    }

    public ActionResultType castOnSelf(Entity sender) {
        return ActionResultType.PASS;
    }

    public void addSpellInstance(AbstractSpellInstance instance) {
        SpellTickManager.getInstance(instance.sender.field_70170_p).addSpellInstance(instance);
    }

    public boolean consume(Entity sender, boolean simulate) {
        if (!(sender instanceof PlayerEntity) || !((PlayerEntity)sender).func_184812_l_()) {
            int consumeAmount = Math.round((float)this.getConsumeAmount() * ToolInfusionHelper.getElementCostReduction(sender));
            return CapabilityElementStorage.get((ICapabilityProvider)sender).map(holder -> holder.extractElement(consumeAmount, this.getElementType(), simulate) >= consumeAmount).orElse(false);
        }
        return true;
    }

    protected boolean consume(Entity sender, IItemProvider item, int count, boolean simulate) {
        if (sender instanceof PlayerEntity && !((PlayerEntity)sender).func_184812_l_()) {
            PlayerInventory inv = ((PlayerEntity)sender).field_71071_by;
            int slot = ECInventoryHelper.getSlotFor((IInventory)inv, new ItemStack(item));
            if (slot >= 0) {
                ItemStack stack = inv.func_70301_a(slot);
                int size = Math.min(count, stack.func_190916_E());
                if (!simulate) {
                    stack.func_190918_g(size);
                    if (stack.func_190926_b()) {
                        inv.func_70299_a(slot, ItemStack.field_190927_a);
                    }
                }
                if (size < count) {
                    return this.consume(sender, item, count - size, simulate);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void setProperties(SpellProperties properties) {
        this.properties = properties;
    }

    public int getCooldown() {
        return this.properties.getCooldown();
    }

    public int getConsumeAmount() {
        return this.properties.getConsumeAmount();
    }

    @Override
    public ElementType getElementType() {
        return this.properties.getElementType();
    }

    public Type getSpellType() {
        return this.properties.getSpellType();
    }

    public int getUseDuration() {
        return this.properties.getUseDuration();
    }

    public int getWeight() {
        return this.properties.getWeight();
    }

    public float getRange(Entity sender) {
        int bonus = 0;
        if (StreamSupport.stream(sender.func_184214_aD().spliterator(), false).anyMatch(s -> !s.func_190926_b() && s.func_77973_b() == ECItems.STAFF)) {
            ++bonus;
        }
        return this.properties.getRange() + (float)bonus;
    }

    public int getColor() {
        return this.properties.getColor();
    }

    public boolean isChannelable() {
        return this.getUseDuration() > 0;
    }

    public boolean isValid() {
        return this.getSpellType() != Type.NONE && this.getElementType() != ElementType.NONE;
    }

    public void addInformation(List<ITextComponent> tooltip) {
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static enum Type implements IStringSerializable
    {
        NONE("none"),
        COMBAT("combat"),
        UTILITY("utility"),
        MIXED("mixed");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NONE;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(Type::values, Type::byName);
        }
    }
}

