/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.infuser.IInfuser;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class InfusionRecipe
extends AbstractInstrumentRecipe<IInfuser>
implements IInfusionRecipe {
    @ObjectHolder(value="elementalcraft:infusion")
    public static final IRecipeSerializer<InfusionRecipe> SERIALIZER = null;
    private final Ingredient input;
    private final ItemStack output;
    private final int elementAmount;

    public InfusionRecipe(ResourceLocation id, ElementType type, int elementAmount, ItemStack output, Ingredient input) {
        super(id, type);
        this.input = input;
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfusionRecipe> {
        public InfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ElementType type = ElementType.byName(JSONUtils.func_151200_h((JsonObject)json, (String)"element_type"));
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            Ingredient input = RecipeHelper.deserializeIngredient(json, "input");
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new InfusionRecipe(recipeId, type, elementAmount, output, input);
        }

        public InfusionRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ElementType type = ElementType.byName(buffer.func_218666_n());
            int elementAmount = buffer.readInt();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            return new InfusionRecipe(recipeId, type, elementAmount, output, input);
        }

        public void toNetwork(PacketBuffer buffer, InfusionRecipe recipe) {
            buffer.func_180714_a(recipe.getElementType().func_176610_l());
            buffer.writeInt(recipe.getElementAmount());
            recipe.getInput().func_199564_a(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

