/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.inventory.ECInventoryHelper;

public class RecipeHelper {
    private RecipeHelper() {
    }

    public static Ingredient deserializeIngredient(JsonObject json, String key) {
        if (JSONUtils.func_151202_d((JsonObject)json, (String)key)) {
            return Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)key));
        }
        return Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)key));
    }

    public static ItemStack readRecipeOutput(JsonObject json, String key) {
        if (json.has(key)) {
            JsonElement element = json.get(key);
            if (element.isJsonPrimitive()) {
                return RecipeHelper.readRecipeOutput(element.getAsString());
            }
            return ShapedRecipe.func_199798_a((JsonObject)element.getAsJsonObject());
        }
        throw new JsonSyntaxException("Missing " + key + ", expected to find a string");
    }

    private static ItemStack readRecipeOutput(String output) {
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(output)));
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray json) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static boolean matchesUnordered(IInventory inv, List<Ingredient> ingredients) {
        HashSet usedIndex = Sets.newHashSet();
        int count = ECInventoryHelper.getItemCount(inv);
        return ingredients.stream().allMatch(ingredient -> {
            for (int i = 0; i < count; ++i) {
                if (!ingredient.test(inv.func_70301_a(i)) || usedIndex.contains(i)) continue;
                usedIndex.add(i);
                return true;
            }
            return false;
        }) && usedIndex.size() == count;
    }
}

