/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.recipe.IInventoryTileRecipe;
import sirttas.elementalcraft.recipe.RecipeHelper;

public class PureInfusionRecipe
implements IInventoryTileRecipe<PureInfuserBlockEntity> {
    public static final String NAME = "pureinfusion";
    public static final IRecipeType<PureInfusionRecipe> TYPE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ElementalCraft.createRL("pureinfusion"), (Object)new IRecipeType<PureInfusionRecipe>(){

        public String toString() {
            return PureInfusionRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:pureinfusion")
    public static final IRecipeSerializer<PureInfusionRecipe> SERIALIZER = null;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final int elementAmount;
    private final ResourceLocation id;

    public PureInfusionRecipe(ResourceLocation id, int elementAmount, ItemStack output, List<Ingredient> ingredients) {
        this.id = id;
        this.ingredients = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.stream().toArray(Ingredient[]::new));
        this.output = output;
        this.elementAmount = elementAmount;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    @Override
    public boolean matches(PureInfuserBlockEntity inv) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem()) && ((Ingredient)this.ingredients.get(1)).test(inv.getStackInPedestal(ElementType.WATER)) && ((Ingredient)this.ingredients.get(2)).test(inv.getStackInPedestal(ElementType.FIRE)) && ((Ingredient)this.ingredients.get(3)).test(inv.getStackInPedestal(ElementType.EARTH)) && ((Ingredient)this.ingredients.get(4)).test(inv.getStackInPedestal(ElementType.AIR));
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public ItemStack assemble(PureInfuserBlockEntity inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public void process(PureInfuserBlockEntity instrument) {
        instrument.getInventory().func_70299_a(0, this.assemble(instrument));
        instrument.emptyPedestals();
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PureInfusionRecipe> {
        public PureInfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new PureInfusionRecipe(recipeId, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public PureInfusionRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int elementAmount = buffer.readInt();
            ItemStack output = buffer.func_150791_c();
            int i = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new PureInfusionRecipe(recipeId, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public void toNetwork(PacketBuffer buffer, PureInfusionRecipe recipe) {
            buffer.writeInt(recipe.elementAmount);
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
        }
    }
}

