/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.mixin;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

@Mixin(value={EnchantmentHelper.class})
public abstract class MixinEnchantmentHelper {
    @Unique
    private static final ThreadLocal<ItemStack> STACK = ThreadLocal.withInitial(() -> ItemStack.field_190927_a);
    @Unique
    private static final ThreadLocal<String> ENCHANTMENT_ID = ThreadLocal.withInitial(() -> "");

    @Inject(method={"getItemEnchantmentLevel(Lnet/minecraft/enchantment/Enchantment;Lnet/minecraft/item/ItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getEnchantmentLevelReturn(Enchantment enchID, ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        int value = ToolInfusionHelper.getInfusionEnchantmentLevel(stack, enchID);
        if (value > 0) {
            cir.setReturnValue((Object)(cir.getReturnValueI() + value));
        }
    }

    @Inject(method={"runIterationOnItem(Lnet/minecraft/enchantment/EnchantmentHelper$IEnchantmentVisitor;Lnet/minecraft/item/ItemStack;)V"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/nbt/CompoundNBT;getString(Ljava/lang/String;)Ljava/lang/String;")})
    private static void applyEnchantmentModifierHead(EnchantmentHelper.IEnchantmentVisitor modifier, ItemStack stack, CallbackInfo ci, ListNBT listnbt, int i, String s) {
        STACK.set(stack);
        ENCHANTMENT_ID.set(s);
    }

    @ModifyVariable(method={"runIterationOnItem(Lnet/minecraft/enchantment/EnchantmentHelper$IEnchantmentVisitor;Lnet/minecraft/item/ItemStack;)V"}, index=5, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/nbt/CompoundNBT;getInt(Ljava/lang/String;)I", shift=At.Shift.AFTER))
    private static int applyEnchantmentModifierSetLevel(int j) {
        Enchantment enchanment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)ENCHANTMENT_ID.get()));
        int value = enchanment != null ? ToolInfusionHelper.getInfusionEnchantmentLevel(STACK.get(), enchanment) : 0;
        STACK.remove();
        ENCHANTMENT_ID.remove();
        return j + value;
    }
}

