/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.jewel.JewelType;

public abstract class AbstractJewel {
    public static final Codec<AbstractJewel> CODEC = CodecHelper.getRegistryCodec(() -> JewelType.REGISTRY).dispatch(AbstractJewel::getType, JewelType::getCodec);
    private ResourceLocation id;
    private final ElementType elementType;
    private final int consumption;

    protected AbstractJewel(ElementType elementType, int consumption) {
        this.elementType = elementType;
        this.consumption = consumption;
    }

    protected static <U extends AbstractJewel> Products.P2<RecordCodecBuilder.Mu<U>, ElementType, Integer> codec(RecordCodecBuilder.Instance<U> builder) {
        return builder.group(ElementType.forGetter(AbstractJewel::getElementType), (App)Codec.INT.fieldOf("consumption").forGetter(AbstractJewel::getConsumption));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public final void setId(ResourceLocation id) {
        this.id = id;
    }

    abstract JewelType<? extends AbstractJewel> getType();

    public ElementType getElementType() {
        return this.elementType;
    }

    public int getConsumption() {
        return this.consumption;
    }

    public boolean isActive(Entity entity) {
        return CapabilityElementStorage.get((ICapabilityProvider)entity).map(s -> s.extractElement(this.consumption, this.elementType, true) == this.consumption).orElse(false);
    }

    public void consume(Entity entity) {
        CapabilityElementStorage.get((ICapabilityProvider)entity).ifPresent(s -> {
            if (s.extractElement(this.consumption, this.elementType, true) == this.consumption) {
                s.extractElement(this.consumption, this.elementType, false);
            }
        });
    }
}

