/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pureore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.event.DataPackReloadCompletEvent;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.recipe.instrument.io.PurifierRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class PureOreManager {
    private final Map<Item, Entry> pureOres = new HashMap<Item, Entry>();

    public ItemStack getOre(ItemStack stack) {
        return NBTHelper.readItemStack(NBTHelper.getECTag(stack), "ore");
    }

    public boolean isValidOre(ItemStack ore) {
        return this.pureOres.containsKey(ore.func_77973_b());
    }

    public ItemStack createPureOre(Item item) {
        ItemStack stack = new ItemStack((IItemProvider)ECItems.PURE_ORE);
        NBTHelper.writeItemStack(NBTHelper.getOrCreateECTag(stack), "ore", new ItemStack((IItemProvider)(this.pureOres.containsKey(item) ? this.pureOres.get((Object)item).ore : item)));
        return stack;
    }

    public int getColor(ItemStack stack) {
        return Optional.of(stack).map(this::getOre).map(i -> this.pureOres.get(i.func_77973_b())).map(o -> o.color).orElse(-1);
    }

    public List<Item> getOres() {
        return this.pureOres.values().stream().distinct().map(o -> o.ore).distinct().collect(Collectors.toList());
    }

    public List<PurifierRecipe> getRecipes() {
        return this.pureOres.entrySet().stream().collect(Collectors.groupingBy(e -> ((Entry)e.getValue()).ore, Collectors.mapping(e -> new ItemStack((IItemProvider)e.getKey()), Collectors.toList()))).values().stream().filter(e -> !e.isEmpty()).map(JEIPurifierRecipe::new).collect(Collectors.toList());
    }

    private Collection<AbstractPureOreRecipeInjector<?, ? extends IRecipe<?>>> getInjectors() {
        return AbstractPureOreRecipeInjector.REGISTRY.getValues();
    }

    private void generatePureOres(RecipeManager recipeManager) {
        Collection<AbstractPureOreRecipeInjector<?, IRecipe<?>>> injectors = this.getInjectors();
        ElementalCraftApi.LOGGER.info("Pure ore generation started.\r\n\tRecipe Types: {}\r\n\tOres found: {}", new Supplier[]{() -> injectors.stream().map(AbstractPureOreRecipeInjector::toString).collect(Collectors.joining(", ")), () -> ECTags.Items.PURE_ORES.func_230236_b_().stream().map(o -> o.getRegistryName().toString()).collect(Collectors.joining(", "))});
        injectors.forEach(injector -> injector.init(recipeManager));
        for (Item ore : ECTags.Items.PURE_ORES.func_230236_b_()) {
            Entry entry = new Entry(ore);
            boolean isInBlacklist = ECTags.Items.PURE_ORES_MOD_PROCESSING_BLACKLIST.func_230235_a_((Object)ore);
            injectors.forEach(injector -> {
                block3: {
                    block2: {
                        if (!injector.isModProcessing()) break block2;
                        if (isInBlacklist) break block3;
                    }
                    injector.getRecipe(ore).ifPresent(entry::addRecipe);
                }
            });
            this.addEntry(entry);
        }
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreRecipeInjection.get())) {
            ElementalCraftApi.LOGGER.info("Pure ore recipe injection");
            List entries = this.pureOres.values().stream().distinct().collect(Collectors.toList());
            recipeManager.field_199522_d = recipeManager.field_199522_d.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            injectors.forEach(injector -> this.inject((AbstractPureOreRecipeInjector)((Object)injector), entries));
            recipeManager.field_199522_d = (Map)recipeManager.field_199522_d.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        ElementalCraftApi.LOGGER.info("Pure ore generation ended");
    }

    private <C extends IInventory, T extends IRecipe<C>> void inject(AbstractPureOreRecipeInjector<C, T> injector, List<Entry> entries) {
        Map<ResourceLocation, T> map = injector.getRecipes();
        map.putAll(entries.stream().distinct().map(entry -> this.injectEntry(injector, (Entry)entry)).filter(Objects::nonNull).collect(Collectors.toMap(IRecipe::func_199560_c, o -> o, (recipe1, recipe2) -> {
            ElementalCraftApi.LOGGER.warn("Duplicated key for type {}: {}", injector.getRecipeType(), (Object)recipe1.func_199560_c());
            return recipe1;
        })));
        injector.inject(map);
    }

    public <C extends IInventory, T extends IRecipe<C>> T injectEntry(AbstractPureOreRecipeInjector<C, T> injector, Entry entry) {
        IRecipeType<T> recipeType = injector.getRecipeType();
        try {
            T recipe = entry.getRecipe(recipeType);
            return recipe != null ? (T)injector.build(recipe, entry.getIngredient()) : null;
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.error("Error in pure ore recipe injection", (Throwable)e);
            return null;
        }
    }

    private void addEntry(Entry entry) {
        if (entry.isValid()) {
            for (Entry other : this.pureOres.values()) {
                if (!entry.match(other)) continue;
                this.pureOres.put(entry.ore, other);
                entry.recipes.forEach((type, recipe) -> {
                    if (!other.recipes.containsKey(type)) {
                        other.addRecipe(recipe);
                    }
                });
                other.ingredients.add((Ingredient)new PureOreIngredient(this.createPureOre(entry.ore)));
                return;
            }
            this.pureOres.put(entry.ore, entry);
        }
    }

    public void reload(DataPackReloadCompletEvent event) {
        this.generatePureOres(event.getRecipeManager());
    }

    private static class JEIPurifierRecipe
    extends PurifierRecipe {
        public JEIPurifierRecipe(List<ItemStack> ores) {
            super(ores.get(0));
            this.input = Ingredient.func_193369_a((ItemStack[])((ItemStack[])ores.stream().toArray(ItemStack[]::new)));
        }
    }

    private static class PureOreCompoundIngredient
    extends CompoundIngredient {
        protected PureOreCompoundIngredient(List<Ingredient> children) {
            super(children);
        }
    }

    private static class PureOreIngredient
    extends NBTIngredient {
        public PureOreIngredient(ItemStack stack) {
            super(stack);
        }
    }

    protected class Entry {
        Item ore;
        List<Ingredient> ingredients;
        ItemStack result;
        int color;
        Map<IRecipeType<?>, IRecipe<?>> recipes = new HashMap();

        public Entry(Item ore) {
            this.ore = ore;
            this.ingredients = Lists.newArrayList((Object[])new Ingredient[]{new PureOreIngredient(PureOreManager.this.createPureOre(ore))});
            this.result = ItemStack.field_190927_a;
        }

        public <C extends IInventory, T extends IRecipe<C>> T getRecipe(IRecipeType<T> recipeType) {
            return (T)this.recipes.get(recipeType);
        }

        public <C extends IInventory, T extends IRecipe<C>> void addRecipe(T recipe) {
            IRecipeType recipeType = recipe.func_222127_g();
            this.recipes.put(recipe.func_222127_g(), recipe);
            if (this.result.func_190926_b()) {
                this.result = PureOreManager.this.getInjectors().stream().filter(injector -> injector.getRecipeType().equals(recipeType)).findAny().map(injector -> injector.getRecipeOutput(recipe)).filter(stack -> !stack.func_190926_b()).orElse(recipe.func_77571_b());
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    this.color = ECItem.lookupColor(this.result);
                });
            }
        }

        public Ingredient getIngredient() {
            return new PureOreCompoundIngredient(this.ingredients);
        }

        public boolean match(Entry other) {
            if (other.isValid() && this.isValid()) {
                if (!other.result.func_190926_b() && !this.result.func_190926_b() && ECInventoryHelper.stackEqualCount(other.result, this.result)) {
                    return true;
                }
                for (IRecipe<?> recipe : other.recipes.values()) {
                    if (!this.recipes.containsValue(recipe)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isValid() {
            return !this.recipes.isEmpty();
        }
    }
}

