/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.property.ECProperties;

public abstract class AbstractElementHolderItem
extends ECItem
implements ISourceInteractable {
    private static final String SAVED_POS = "saved_pos";
    protected final int elementCapacity;
    protected final int transferAmount;

    protected AbstractElementHolderItem(int elementCapacity, int transferAmount) {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
        this.elementCapacity = elementCapacity;
        this.transferAmount = transferAmount;
    }

    public abstract IElementStorage getElementStorage(ItemStack var1);

    public int func_77626_a(ItemStack stack) {
        return this.elementCapacity / this.transferAmount;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    protected boolean isValidSource(BlockState state) {
        return state.func_177230_c().equals((Object)ECBlocks.SOURCE);
    }

    @Override
    public boolean canIteractWithSource(ItemStack stack, BlockState state) {
        return this.isValidSource(state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        ActionResultType result = this.tick(world, (LivingEntity)player, pos, stack);
        if (result.func_226246_a_()) {
            this.setSavedPos(stack, pos);
            player.func_184598_c(context.func_221531_n());
        }
        return result;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        BlockPos pos = this.getSavedPos(stack);
        double reach = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        if (player.func_233580_cy_().func_177951_i((Vector3i)pos) + 1.0 > reach * reach || !this.tick(player.func_130014_f_(), player, pos, stack).func_226246_a_()) {
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        this.removeSavedPos(stack);
    }

    protected abstract ElementType getElementType(IElementStorage var1, BlockState var2);

    private ActionResultType tick(World world, LivingEntity entity, BlockPos pos, ItemStack stack) {
        BlockState blockstate = world.func_180495_p(pos);
        return BlockEntityHelper.getElementStorageAt((IWorldReader)world, pos).map(storage -> {
            IElementStorage holder = this.getElementStorage(stack);
            boolean isSource = this.isValidSource(blockstate);
            ElementType elementType = this.getElementType((IElementStorage)storage, blockstate);
            if (elementType != ElementType.NONE) {
                if (isSource || entity.func_225608_bj_()) {
                    if (isSource || storage.canPipeExtract(elementType)) {
                        return storage.transferTo(holder, elementType, this.transferAmount) > 0 ? ActionResultType.CONSUME : ActionResultType.PASS;
                    }
                } else if (storage.canPipeInsert(elementType)) {
                    return holder.transferTo((IElementStorage)storage, elementType, this.transferAmount) > 0 ? ActionResultType.CONSUME : ActionResultType.PASS;
                }
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public BlockPos getSavedPos(ItemStack stack) {
        CompoundNBT savedPos;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (savedPos = tag.func_74775_l(SAVED_POS)) != null) {
            return NBTUtil.func_186861_c((CompoundNBT)savedPos);
        }
        return null;
    }

    public void setSavedPos(ItemStack stack, BlockPos pos) {
        stack.func_196082_o().func_218657_a(SAVED_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
    }

    public void removeSavedPos(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(SAVED_POS);
        }
    }
}

