/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.elemental;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.elemental.ElementalItem;
import sirttas.elementalcraft.property.ECProperties;

public class LenseItem
extends ElementalItem {
    private static final String NAME = "lense";
    public static final String NAME_FIRE = "fire_lense";
    public static final String NAME_WATER = "water_lense";
    public static final String NAME_EARTH = "earth_lense";
    public static final String NAME_AIR = "air_lense";

    public LenseItem(ElementType elementType) {
        super(ECProperties.Items.LENSE, elementType);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> new Storage(stack, (Integer)ECConfig.COMMON.lenseElementMultiplier.get())));
            }
        };
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s;
    }

    private class Storage
    implements ISingleElementStorage {
        private final int multiplier;
        private final ItemStack stack;

        private Storage(ItemStack stack, int multiplier) {
            this.stack = stack;
            this.multiplier = multiplier;
        }

        @Override
        public ElementType getElementType() {
            return LenseItem.this.elementType;
        }

        @Override
        public int getElementAmount() {
            return (this.stack.func_77958_k() - this.stack.func_77952_i()) * this.multiplier;
        }

        @Override
        public int getElementCapacity() {
            return this.stack.func_77958_k() * this.multiplier;
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            return count;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            if (!this.stack.func_77984_f()) {
                return count;
            }
            ItemStack target = simulate ? this.stack.func_77946_l() : this.stack;
            int damage = target.func_77952_i();
            target.func_96631_a(count / this.multiplier, new Random(), null);
            return (target.func_77952_i() - damage) * this.multiplier;
        }
    }
}

