/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import mezz.jei.color.ColorGetter;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.property.ECProperties;

public class ECItem
extends Item {
    private static boolean noJeiLogged = false;
    private boolean glint = false;

    public ECItem() {
        this(ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
    }

    public ECItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.glint || super.func_77636_d(stack);
    }

    public ECItem setEffect(boolean glint) {
        this.glint = glint;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final int lookupColor(ItemStack stack) {
        block3: {
            try {
                List colors = ColorGetter.getColors((ItemStack)stack, (int)2);
                if (colors != null && !colors.isEmpty()) {
                    return (Integer)colors.get(0);
                }
            }
            catch (NoClassDefFoundError e) {
                if (noJeiLogged) break block3;
                ElementalCraftApi.LOGGER.warn("JEI not present, can't lookup item colors", (Throwable)e);
                noJeiLogged = true;
            }
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addAttributeMultimapToTooltip(List<ITextComponent> tooltip, Multimap<Attribute, AttributeModifier> multimap, ITextComponent title) {
        if (!multimap.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add(title);
            for (Map.Entry entry : multimap.entries()) {
                tooltip.add((ITextComponent)ECItem.getAttributeTooltip((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IFormattableTextComponent getAttributeTooltip(Attribute attribute, AttributeModifier attributemodifier) {
        double d0 = attributemodifier.func_111164_d();
        double d1 = attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.field_233820_c_) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (d0 > 0.0) {
            return new TranslationTextComponent("attribute.modifier.plus." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE);
        }
        if (d0 < 0.0) {
            return new TranslationTextComponent("attribute.modifier.take." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.RED);
        }
        return null;
    }
}

