/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;

public class ElementIngredientRenderer
implements IIngredientRenderer<IngredientElementType> {
    public void render(MatrixStack matrixStack, int x, int y, IngredientElementType ingredient) {
        if (ingredient != null) {
            int amount = ingredient.getAmount();
            GuiHelper.renderElementGauge(matrixStack, x, y, amount == -1 ? 4 : amount, 4, ingredient.getType(), false);
        }
    }

    public List<ITextComponent> getTooltip(IngredientElementType ingredient, ITooltipFlag tooltipFlag) {
        ArrayList tooltips = Lists.newArrayList();
        int amount = ingredient.getAmount();
        tooltips.add(ingredient.getDisplayName());
        if (amount != -1) {
            tooltips.add(new TranslationTextComponent("tooltip.elemntalcraft.element_amount." + amount).func_240699_a_(TextFormatting.GREEN));
        }
        return tooltips;
    }
}

