/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.shrine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.data.predicate.block.shrine.IShrinePredicate;

public class HasShrineUpgradePredicate
implements IShrinePredicate {
    public static final String NAME = "has_shrien_upgrade";
    @ObjectHolder(value="elementalcraft:has_shrien_upgrade")
    public static final BlockPosPredicateType<HasShrineUpgradePredicate> TYPE = null;
    public static final Codec<HasShrineUpgradePredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.field_240908_a_.fieldOf("shrine_upgrade").forGetter(p -> p.upgradeId), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, HasShrineUpgradePredicate::new));
    private final int count;
    private final ResourceLocation upgradeId;
    private ShrineUpgrade upgrade;

    public HasShrineUpgradePredicate(ShrineUpgrade upgrade) {
        this(upgrade, 1);
    }

    public HasShrineUpgradePredicate(ShrineUpgrade upgrade, int count) {
        this(upgrade.getId(), count);
        this.upgrade = upgrade;
    }

    public HasShrineUpgradePredicate(ResourceLocation upgradeId) {
        this(upgradeId, 1);
    }

    public HasShrineUpgradePredicate(ResourceLocation upgradeId, int count) {
        this.upgradeId = upgradeId;
        this.count = count;
    }

    @Override
    public boolean test(AbstractShrineBlockEntity shrine) {
        if (this.upgrade == null) {
            this.upgrade = (ShrineUpgrade)ElementalCraft.SHRINE_UPGRADE_MANAGER.get(this.upgradeId);
        }
        return shrine.getUpgradeCount(this.upgrade) >= this.count;
    }

    public BlockPosPredicateType<HasShrineUpgradePredicate> getType() {
        return TYPE;
    }
}

