/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.rune;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.data.predicate.block.rune.IRunePredicate;

public class HasRunePredicate
implements IRunePredicate {
    public static final String NAME = "has_rune";
    @ObjectHolder(value="elementalcraft:has_rune")
    public static final BlockPosPredicateType<HasRunePredicate> TYPE = null;
    public static final Codec<HasRunePredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.field_240908_a_.fieldOf("rune").forGetter(p -> p.runeId), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, HasRunePredicate::new));
    private final int count;
    private final ResourceLocation runeId;
    private Rune rune;

    public HasRunePredicate(Rune rune) {
        this(rune, 1);
    }

    public HasRunePredicate(Rune rune, int count) {
        this(rune.getId(), count);
        this.rune = rune;
    }

    public HasRunePredicate(ResourceLocation runeId) {
        this(runeId, 1);
    }

    public HasRunePredicate(ResourceLocation runeId, int count) {
        this.runeId = runeId;
        this.count = count;
    }

    @Override
    public boolean test(IRuneHandler handler) {
        if (this.rune == null) {
            this.rune = (Rune)ElementalCraftApi.RUNE_MANAGER.get(this.runeId);
        }
        return handler.getRuneCount(this.rune) >= this.count;
    }

    public BlockPosPredicateType<HasRunePredicate> getType() {
        return TYPE;
    }
}

