/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.StaticElementStorage;
import sirttas.elementalcraft.config.ECConfig;

public class SourceElementStorage
extends StaticElementStorage {
    private boolean exhausted = false;

    public SourceElementStorage(int capacity, Runnable syncCallback) {
        super(ElementType.NONE, capacity, syncCallback);
        this.elementAmount = this.elementCapacity;
    }

    protected void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        int value = super.insertElement(count, type, simulate);
        if (!simulate && (float)this.getElementAmount() >= (float)this.elementCapacity * 0.9f) {
            this.exhausted = false;
        }
        return value;
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        if (Boolean.TRUE.equals(ECConfig.COMMON.disableSourceExhaustion.get())) {
            return count;
        }
        if (!this.exhausted) {
            int value = super.extractElement(count, type, simulate);
            if (!simulate && (float)this.getElementAmount() <= (float)this.elementCapacity * 0.1f) {
                this.exhausted = true;
            }
            return value;
        }
        return 0;
    }

    @Override
    public boolean canPipeInsert(ElementType elementType) {
        return false;
    }

    @Override
    public boolean canPipeExtract(ElementType elementType) {
        return false;
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    protected void setExhausted(boolean exausted) {
        this.exhausted = exausted;
    }
}

