/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import net.minecraft.block.BlockState;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.block.shape.Shapes;

public interface ISorterBlock {
    public static final DirectionProperty SOURCE = DirectionProperty.func_196962_a((String)"source", (Direction[])Direction.values());
    public static final DirectionProperty TARGET = DirectionProperty.func_196962_a((String)"target", (Direction[])Direction.values());

    default public VoxelShape getSourceShape(BlockState state) {
        return Shapes.sourceShape((Direction)state.func_177229_b((Property)SOURCE));
    }

    default public VoxelShape getTargetShape(BlockState state) {
        return Shapes.targetShape((Direction)state.func_177229_b((Property)TARGET));
    }

    public VoxelShape getCoreShape(BlockState var1);

    default public VoxelShape getCurentShape(BlockState state) {
        return VoxelShapes.func_216384_a((VoxelShape)this.getSourceShape(state), (VoxelShape[])new VoxelShape[]{this.getTargetShape(state), this.getCoreShape(state)}).func_197753_c();
    }

    default public VoxelShape getShape(BlockState state, BlockPos pos, RayTraceResult result) {
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK && ((BlockRayTraceResult)result).func_216350_a().equals((Object)pos)) {
            Vector3d hit = result.func_216347_e();
            VoxelShape source = this.getSourceShape(state);
            VoxelShape target = this.getTargetShape(state);
            VoxelShape core = this.getCoreShape(state);
            if (ShapeHelper.vectorCollideWithShape(source, pos, hit)) {
                return source;
            }
            if (ShapeHelper.vectorCollideWithShape(target, pos, hit)) {
                return target;
            }
            if (ShapeHelper.vectorCollideWithShape(core, pos, hit)) {
                return core;
            }
        }
        return this.getCurentShape(state);
    }

    default public ActionResultType moveIO(BlockState state, World world, BlockPos pos, BlockRayTraceResult hit) {
        return this.moveIO(state, world, pos, hit, this.getShape(state, pos, (RayTraceResult)hit));
    }

    default public ActionResultType moveIO(BlockState state, World world, BlockPos pos, BlockRayTraceResult hit, VoxelShape shape) {
        Direction direction = hit.func_216354_b().func_176734_d();
        if (state.func_177229_b((Property)SOURCE) == direction || state.func_177229_b((Property)TARGET) == direction) {
            return ActionResultType.PASS;
        }
        if (Shapes.SOURCE_SHAPES.contains(shape)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SOURCE, (Comparable)direction));
            return ActionResultType.SUCCESS;
        }
        if (Shapes.TARGET_SHAPES.contains(shape)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)TARGET, (Comparable)direction));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

