/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.solarsynthesizer;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleItemInventory;
import sirttas.elementalcraft.particle.ParticleHelper;

public class SolarSynthesizerBlockEntity
extends AbstractECContainerBlockEntity {
    @ObjectHolder(value="elementalcraft:solar_synthesizer")
    public static final TileEntityType<SolarSynthesizerBlockEntity> TYPE = null;
    private final SingleItemInventory inventory = new SingleItemInventory(this::func_70296_d);
    private final RuneHandler runeHandler;
    private boolean working;

    public SolarSynthesizerBlockEntity() {
        super(TYPE);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.solarSythesizerMaxRunes.get());
        this.working = false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ISingleElementStorage tank = this.getTank();
        if (tank != null && this.field_145850_b.func_230315_m_().func_218272_d() && this.field_145850_b.func_226660_f_(this.field_174879_c) && this.field_145850_b.func_72935_r()) {
            ItemStack stack = this.inventory.func_70301_a(0);
            boolean hasExtract = this.getElementStorage().map(storage -> storage.transferTo((IElementStorage)tank, this.runeHandler.getTransferSpeed(((Integer)ECConfig.COMMON.lenseElementMultiplier.get()).intValue()), this.runeHandler.getElementPreservation()) > 0).orElse(false);
            if (hasExtract || this.working) {
                this.working = hasExtract;
                this.func_70296_d();
            }
            if (!stack.func_190926_b() && stack.func_77952_i() >= stack.func_77958_k()) {
                Vector3d position = Vector3d.func_237489_a_((Vector3i)this.field_174879_c).func_72441_c(0.0, 0.40625, 0.0);
                this.inventory.func_70299_a(0, ItemStack.field_190927_a);
                this.field_145850_b.func_184134_a(position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f, false);
                ParticleHelper.createItemBreakParticle(this.field_145850_b, position, this.field_145850_b.field_73012_v, stack, 3);
                this.func_70296_d();
            }
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.func_150295_c("rune_handler", 8));
        }
        this.working = compound.func_74767_n("working");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("rune_handler", (INBT)IRuneHandler.writeNBT(this.runeHandler));
        compound.func_74757_a("working", this.working);
        return compound;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f) {
            if (cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
                return CapabilityElementStorage.get((ICapabilityProvider)this.inventory.func_70301_a(0)).cast();
            }
            if (cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
                return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public Optional<ISingleElementStorage> getElementStorage() {
        return CapabilityElementStorage.get((ICapabilityProvider)this).filter(ISingleElementStorage.class::isInstance).map(ISingleElementStorage.class::cast);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

