/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.enderlock;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;

public class EnderLockShrineBlockEntity
extends AbstractShrineBlockEntity {
    @ObjectHolder(value="elementalcraft:enderlockshrine")
    public static final TileEntityType<EnderLockShrineBlockEntity> TYPE = null;
    private static final AbstractShrineBlockEntity.Properties PROPERTIES = AbstractShrineBlockEntity.Properties.create(ElementType.WATER).consumeAmount((Integer)ECConfig.COMMON.enderLockShrineConsumeAmount.get()).range(((Integer)ECConfig.COMMON.enderLockShrineRange.get()).intValue());
    protected static final List<Direction> UPGRRADE_DIRECTIONS = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);

    public EnderLockShrineBlockEntity() {
        super(TYPE, PROPERTIES);
    }

    @Override
    public AxisAlignedBB getRangeBoundingBox() {
        int range = (Integer)ECConfig.COMMON.enderLockShrineRange.get();
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)range, 0.0, (double)range).func_72321_a(0.0, 2.0, 0.0);
    }

    @Override
    protected boolean doTick() {
        return false;
    }

    public boolean doLock(LivingEntity entity) {
        int consumeAmount = this.getConsumeAmount();
        if ((!this.hasUpgrade(ShrineUpgrades.PROTECTION) || EntityHelper.isHostile((Entity)entity)) && this.elementStorage.getElementAmount() >= consumeAmount) {
            this.consumeElement(consumeAmount);
            return true;
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRRADE_DIRECTIONS;
    }
}

