/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.Shapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlockEntity;

public class BreedingShrineBlock
extends AbstractShrineBlock {
    public static final String NAME = "breedingshrine";
    private static final VoxelShape BASE_CORE = VoxelShapes.func_197872_a((VoxelShape)Shapes.SHRINE_SHAPE, (VoxelShape)Block.func_208617_a((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    private static final VoxelShape CORE_NORTH_1 = Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0);
    private static final VoxelShape CORE_NORTH_2 = Block.func_208617_a((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    private static final VoxelShape CORE_SOUTH_1 = Block.func_208617_a((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape CORE_SOUTH_2 = Block.func_208617_a((double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    private static final VoxelShape CORE_WEST_1 = Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0);
    private static final VoxelShape CORE_WEST_2 = Block.func_208617_a((double)0.0, (double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    private static final VoxelShape CORE_EAST_1 = Block.func_208617_a((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape CORE_EAST_2 = Block.func_208617_a((double)11.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape CORE_NORTH = VoxelShapes.func_216384_a((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_NORTH_1, CORE_NORTH_2});
    private static final VoxelShape CORE_SOUTH = VoxelShapes.func_216384_a((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_SOUTH_1, CORE_SOUTH_2});
    private static final VoxelShape CORE_WEST = VoxelShapes.func_216384_a((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_WEST_1, CORE_WEST_2});
    private static final VoxelShape CORE_EAST = VoxelShapes.func_216384_a((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_EAST_1, CORE_EAST_2});
    private static final VoxelShape BASE_BOWL_FULL = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape BASE_BOWL_VOID = Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape BASE_BOWL = VoxelShapes.func_197878_a((VoxelShape)BASE_BOWL_FULL, (VoxelShape)BASE_BOWL_VOID, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape BOWL_NORTH_1 = Block.func_208617_a((double)5.0, (double)7.0, (double)11.0, (double)11.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_NORTH_2 = Block.func_208617_a((double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    private static final VoxelShape BOWL_NORTH_3 = Block.func_208617_a((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOWL_NORTH_TAPE = Block.func_208617_a((double)7.0, (double)10.0, (double)8.0, (double)9.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_SOUTH_1 = Block.func_208617_a((double)5.0, (double)7.0, (double)3.0, (double)11.0, (double)12.0, (double)5.0);
    private static final VoxelShape BOWL_SOUTH_2 = Block.func_208617_a((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    private static final VoxelShape BOWL_SOUTH_3 = Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0);
    private static final VoxelShape BOWL_SOUTH_TAPE = Block.func_208617_a((double)7.0, (double)10.0, (double)5.0, (double)9.0, (double)12.0, (double)8.0);
    private static final VoxelShape BOWL_WEST_1 = Block.func_208617_a((double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_WEST_2 = Block.func_208617_a((double)11.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOWL_WEST_3 = Block.func_208617_a((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_WEST_TAPE = Block.func_208617_a((double)8.0, (double)10.0, (double)7.0, (double)11.0, (double)12.0, (double)9.0);
    private static final VoxelShape BOWL_EAST_1 = Block.func_208617_a((double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_EAST_2 = Block.func_208617_a((double)0.0, (double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOWL_EAST_3 = Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_EAST_TAPE = Block.func_208617_a((double)5.0, (double)10.0, (double)7.0, (double)8.0, (double)12.0, (double)9.0);
    private static final VoxelShape BOWL_NORTH = VoxelShapes.func_216384_a((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_NORTH_1, BOWL_NORTH_2, BOWL_NORTH_3, BOWL_NORTH_TAPE});
    private static final VoxelShape BOWL_SOUTH = VoxelShapes.func_216384_a((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_SOUTH_1, BOWL_SOUTH_2, BOWL_SOUTH_3, BOWL_SOUTH_TAPE});
    private static final VoxelShape BOWL_WEST = VoxelShapes.func_216384_a((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_WEST_1, BOWL_WEST_2, BOWL_WEST_3, BOWL_WEST_TAPE});
    private static final VoxelShape BOWL_EAST = VoxelShapes.func_216384_a((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_EAST_1, BOWL_EAST_2, BOWL_EAST_3, BOWL_EAST_TAPE});
    public static final EnumProperty<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BreedingShrineBlock() {
        super(ElementType.EARTH);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)Part.CORE)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)), (BlockState)state.func_206870_a(PART, (Comparable)((Object)Part.BOWL)), 3);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        Part part = (Part)((Object)state.func_177229_b(PART));
        BlockPos blockpos = pos.func_177972_a(part == Part.CORE ? (Direction)state.func_177229_b((Property)FACING) : ((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(PART) != part) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{FACING, PART});
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(PART) == Part.CORE;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.hasTileEntity(state) ? new BreedingShrineBlockEntity() : null;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(PART) == Part.CORE) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return CORE_NORTH;
                }
                case SOUTH: {
                    return CORE_SOUTH;
                }
                case WEST: {
                    return CORE_WEST;
                }
                case EAST: {
                    return CORE_EAST;
                }
            }
            return BASE_CORE;
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return BOWL_NORTH;
            }
            case SOUTH: {
                return BOWL_SOUTH;
            }
            case WEST: {
                return BOWL_WEST;
            }
            case EAST: {
                return BOWL_EAST;
            }
        }
        return BASE_BOWL;
    }

    public static enum Part implements IStringSerializable
    {
        CORE("core"),
        BOWL("bowl");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

