/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.retriever;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.property.ECProperties;

public class RetrieverBlock
extends Block
implements ISorterBlock {
    public static final String NAME = "instrument_retriever";
    private static final VoxelShape CORE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public RetrieverBlock() {
        super(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SOURCE, (Comparable)Direction.SOUTH)).func_206870_a((Property)TARGET, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SOURCE, (Comparable)direction.func_176734_d())).func_206870_a((Property)TARGET, (Comparable)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{SOURCE, TARGET});
    }

    @Override
    public VoxelShape getCoreShape(BlockState state) {
        return CORE;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return worldIn instanceof World && ((World)worldIn).field_72995_K ? this.getShape(state, pos, Minecraft.func_71410_x().field_71476_x) : this.getCurentShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getCurentShape(state);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.moveIO(state, world, pos, hit);
    }

    public static void sendOutputToRetriever(World world, BlockPos pos, IInventory inventory, int slot) {
        ItemStack stack = inventory.func_70301_a(slot);
        if (!world.func_175640_z(pos) && !stack.func_190926_b()) {
            for (Direction direction : Direction.values()) {
                BlockPos retriverPos = pos.func_177972_a(direction);
                BlockState blockState = world.func_180495_p(retriverPos);
                if (!(blockState.func_177230_c() instanceof RetrieverBlock) || blockState.func_177229_b((Property)SOURCE) != direction.func_176734_d()) continue;
                stack = RetrieverBlock.retrive(blockState, (IBlockReader)world, retriverPos, stack);
                inventory.func_70299_a(slot, stack);
                if (!stack.func_190926_b()) continue;
                return;
            }
        }
    }

    public static ItemStack retrive(BlockState state, IBlockReader world, BlockPos pos, ItemStack output) {
        Direction direction = (Direction)state.func_177229_b((Property)TARGET);
        return ItemHandlerHelper.insertItem((IItemHandler)ECInventoryHelper.getItemHandlerAt(world, pos.func_177972_a(direction), direction.func_176734_d()), (ItemStack)output, (boolean)false);
    }
}

