/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.pedestal.ElementStorageRenderer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.inventory.SingleItemInventory;

public class PedestalBlockEntity
extends AbstractIERBlockEntity
implements IElementTypeProvider {
    @ObjectHolder(value="elementalcraft:pedestal_fire")
    public static final TileEntityType<PedestalBlockEntity> TYPE_FIRE = null;
    @ObjectHolder(value="elementalcraft:pedestal_water")
    public static final TileEntityType<PedestalBlockEntity> TYPE_WATER = null;
    @ObjectHolder(value="elementalcraft:pedestal_earth")
    public static final TileEntityType<PedestalBlockEntity> TYPE_EARTH = null;
    @ObjectHolder(value="elementalcraft:pedestal_air")
    public static final TileEntityType<PedestalBlockEntity> TYPE_AIR = null;
    private final SingleItemInventory inventory = new SingleItemInventory(this::func_70296_d);
    private final SingleElementStorage elementStorage;
    private final RuneHandler runeHandler;

    private PedestalBlockEntity(TileEntityType<?> tileEntityType, ElementType type) {
        super(tileEntityType);
        this.elementStorage = new ElementStorageRenderer(type, this::func_70296_d);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.pedestalMaxRunes.get());
    }

    public static PedestalBlockEntity createFire() {
        return new PedestalBlockEntity(TYPE_FIRE, ElementType.FIRE);
    }

    public static PedestalBlockEntity createWater() {
        return new PedestalBlockEntity(TYPE_WATER, ElementType.WATER);
    }

    public static PedestalBlockEntity createEarth() {
        return new PedestalBlockEntity(TYPE_EARTH, ElementType.EARTH);
    }

    public static PedestalBlockEntity createAir() {
        return new PedestalBlockEntity(TYPE_AIR, ElementType.AIR);
    }

    public Direction getPureInfuserDirection() {
        return Stream.of(Direction.values()).filter(d -> d.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL).filter(d -> this.func_145831_w().func_175625_s(this.field_174879_c.func_177967_a(d, 3)) instanceof PureInfuserBlockEntity).findAny().orElse(Direction.UP);
    }

    @Override
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.func_70301_a(0);
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

