/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface IElementPipe {
    public ConnectionType getConection(Direction var1);

    default public boolean isPriority(Direction face) {
        return false;
    }

    public static enum ConnectionType {
        NONE(0, "none", false),
        CONNECT(1, "connect", true),
        INSERT(2, "insert", true),
        EXTRACT(3, "extract", true),
        DISCONNECT(4, "disconnect", false);

        private final int value;
        private final String translationKey;
        private final boolean connected;

        private ConnectionType(int value, String key, boolean connected) {
            this.value = value;
            this.translationKey = "message.elementalcraft." + key;
            this.connected = connected;
        }

        boolean isConnected() {
            return this.connected;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionType fromInteger(int x) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.getValue() != x) continue;
                return type;
            }
            return NONE;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent(this.translationKey);
        }
    }
}

