/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECTickableBlockEntity;
import sirttas.elementalcraft.config.ECConfig;

public class DiffuserBlockEntity
extends AbstractECTickableBlockEntity {
    @ObjectHolder(value="elementalcraft:diffuser")
    public static final TileEntityType<DiffuserBlockEntity> TYPE = null;
    private boolean hasDiffused;
    private final RuneHandler runeHandler;

    public DiffuserBlockEntity() {
        super(TYPE);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.diffuserMaxRunes.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.hasDiffused = compound.func_74767_n("has_diffused");
        if (compound.func_74764_b("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.func_150295_c("rune_handler", 8));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("has_diffused", this.hasDiffused);
        compound.func_218657_a("rune_handler", (INBT)IRuneHandler.writeNBT(this.runeHandler));
        return compound;
    }

    @Override
    public void func_73660_a() {
        ISingleElementStorage tank = this.getTank();
        AtomicInteger amount = new AtomicInteger((Integer)ECConfig.COMMON.diffuserDiffusionAmount.get());
        this.hasDiffused = false;
        super.func_73660_a();
        if (tank != null && !tank.isEmpty()) {
            this.func_145831_w().func_72839_b(null, new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)((Integer)ECConfig.COMMON.diffuserRange.get()).intValue())).stream().map(CapabilityElementStorage::get).map(LazyOptional::resolve).filter(Optional::isPresent).map(Optional::get).forEach(storage -> {
                if (!tank.isEmpty() && amount.get() > 0) {
                    amount.set(tank.transferTo((IElementStorage)storage, this.runeHandler.getTransferSpeed(amount.get()), this.runeHandler.getElementPreservation()));
                    this.hasDiffused = true;
                }
            });
        }
    }

    public boolean hasDiffused() {
        return this.hasDiffused;
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

