/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.inventory.ECInventoryHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.property.ECProperties;

public abstract class AbstractECBlockEntityProviderBlock
extends Block {
    protected AbstractECBlockEntityProviderBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    protected AbstractECBlockEntityProviderBlock() {
        this(ECProperties.Blocks.BLOCK_NOT_SOLID);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public abstract TileEntity createTileEntity(@Nonnull BlockState var1, @Nonnull IBlockReader var2);

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItems(worldIn, pos);
            this.dropRunes(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void dropItems(World worldIn, BlockPos pos) {
        IItemHandler inv = ECInventoryHelper.getItemHandlerAt((IBlockReader)worldIn, pos, null);
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inv.getStackInSlot(i));
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    private void dropRunes(World worldIn, BlockPos pos) {
        BlockEntityHelper.getRuneHandlerAt((IWorldReader)worldIn, pos).getRunes().forEach(rune -> InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)ECItems.RUNE.getRuneStack((Rune)rune)));
    }
}

