/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.upgrade;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public abstract class AbstractUpgrade<T> {
    private ResourceLocation id;
    protected IBlockPosPredicate predicate;
    protected int maxAmount;
    protected final Map<T, Float> bonuses;

    protected AbstractUpgrade(IBlockPosPredicate predicate, Map<T, Float> map, int maxAmount) {
        this.predicate = predicate;
        this.bonuses = map;
        this.maxAmount = maxAmount;
        this.id = null;
    }

    protected static <T extends IStringSerializable, U extends AbstractUpgrade<T>> Products.P3<RecordCodecBuilder.Mu<U>, IBlockPosPredicate, Map<T, Float>, Integer> codec(RecordCodecBuilder.Instance<U> builder, Codec<T> bonusCodec) {
        return builder.group((App)IBlockPosPredicate.CODEC.fieldOf("predicate").forGetter(u -> u.predicate), (App)Codec.unboundedMap(bonusCodec, (Codec)Codec.FLOAT).optionalFieldOf("bonuses", (Object)ImmutableMap.of()).forGetter(AbstractUpgrade::getBonuses), (App)Codec.INT.optionalFieldOf("max_amount", (Object)0).forGetter(u -> u.maxAmount));
    }

    protected boolean canUpgrade(IWorldReader world, BlockPos pos, int amount) {
        return this.predicate.test(world, pos) && (this.maxAmount == 0 || amount < this.maxAmount);
    }

    protected void merge(AbstractUpgrade<T> other) {
        this.predicate = this.predicate.or(new IBlockPosPredicate[]{other.predicate}).simplify();
        other.bonuses.forEach((bonus, value) -> {
            if (this.bonuses.containsKey(bonus)) {
                this.bonuses.put(bonus, Float.valueOf(this.bonuses.get(bonus).floatValue() * value.floatValue()));
            } else {
                this.bonuses.put((T)bonus, (Float)value);
            }
        });
        if (this.maxAmount == 0) {
            this.maxAmount = other.maxAmount;
        }
    }

    public final Map<T, Float> getBonuses() {
        return this.bonuses;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public final void setId(ResourceLocation id) {
        this.id = id;
    }

    public String toString() {
        return this.id != null ? this.id.toString() : super.toString();
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 1;
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractUpgrade && this.id != null) {
            return this.id.equals((Object)((AbstractUpgrade)other).id);
        }
        return super.equals(other);
    }
}

