/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.rune.handler;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;

public interface IRuneHandler {
    public void addRune(Rune var1);

    public void removeRune(Rune var1);

    public int getRuneCount();

    public int getRuneCount(Rune var1);

    public int getMaxRunes();

    public List<Rune> getRunes();

    public float getBonus(Rune.BonusType var1);

    default public float getTransferSpeed(float baseTransferSpeed) {
        return baseTransferSpeed * (this.getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    default public float getElementPreservation() {
        return this.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
    }

    public static ListNBT writeNBT(IRuneHandler handler) {
        return handler.getRunes().stream().map(rune -> StringNBT.func_229705_a_((String)rune.getId().toString())).collect(Collectors.toCollection(ListNBT::new));
    }

    public static void readNBT(IRuneHandler handler, ListNBT nbtTagList) {
        nbtTagList.forEach(nbt -> {
            String name = ((StringNBT)nbt).func_150285_a_();
            Rune rune = (Rune)ElementalCraftApi.RUNE_MANAGER.get(new ResourceLocation(name));
            if (rune != null) {
                handler.addRune(rune);
            } else {
                ElementalCraftApi.LOGGER.warn("Rune not fount with id: {}", (Object)name);
            }
        });
    }
}

