/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage.single;

import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;

public interface ISingleElementStorage
extends IElementStorage,
IElementTypeProvider {
    public int getElementAmount();

    public int getElementCapacity();

    default public int insertElement(int count, boolean simulate) {
        return this.insertElement(count, this.getElementType(), simulate);
    }

    default public int extractElement(int count, boolean simulate) {
        return this.extractElement(count, this.getElementType(), simulate);
    }

    default public int transferTo(IElementStorage other, int count) {
        return this.transferTo(other, this.getElementType(), count);
    }

    default public int transferTo(IElementStorage other, float count, float multiplier) {
        return this.transferTo(other, this.getElementType(), count, multiplier);
    }

    @Override
    default public int getElementAmount(ElementType type) {
        return type == this.getElementType() ? this.getElementAmount() : 0;
    }

    @Override
    default public int getElementCapacity(ElementType type) {
        return type == this.getElementType() ? this.getElementCapacity() : 0;
    }

    @Override
    default public boolean isEmpty() {
        return this.getElementType() == ElementType.NONE || this.getElementAmount() <= 0;
    }

    @Override
    default public boolean canPipeInsert(ElementType type) {
        return this.isValidType(type);
    }

    @Override
    default public boolean canPipeExtract(ElementType type) {
        return this.isValidType(type);
    }

    @Override
    default public ISingleElementStorage forElement(ElementType type) {
        if (!this.isValidType(type)) {
            return EmptyElementStorage.getSingle(type);
        }
        return this;
    }

    default public boolean isValidType(ElementType type) {
        ElementType localType = this.getElementType();
        return type != ElementType.NONE && (localType == ElementType.NONE || type == localType);
    }
}

