/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BlockPosBasePacket;
import com.supermartijn642.core.network.PacketContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public abstract class TileEntityBasePacket<T extends TileEntity>
extends BlockPosBasePacket {
    public RegistryKey<World> dimension;

    public TileEntityBasePacket() {
    }

    public TileEntityBasePacket(RegistryKey<World> dimension, BlockPos pos) {
        super(pos);
        this.dimension = dimension;
    }

    public TileEntityBasePacket(World world, BlockPos pos) {
        this((RegistryKey<World>)(world == null ? null : world.func_234923_W_()), pos);
    }

    public TileEntityBasePacket(BlockPos pos) {
        this((RegistryKey<World>)((RegistryKey)null), pos);
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.dimension != null);
        if (this.dimension != null) {
            buffer.func_192572_a(this.dimension.func_240901_a_());
        }
    }

    @Override
    public void read(PacketBuffer buffer) {
        super.read(buffer);
        if (buffer.readBoolean()) {
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buffer.func_192575_l());
        }
    }

    @Override
    protected void handle(BlockPos pos, PacketContext context) {
        T tile = this.getTileEntity(context);
        if (tile != null) {
            this.handle(tile, context);
        }
    }

    protected abstract void handle(T var1, PacketContext var2);

    private T getTileEntity(PacketContext context) {
        World world;
        Object object = this.dimension == null ? context.getWorld() : (context.getHandlingSide() == CoreSide.CLIENT ? (context.getWorld().func_234923_W_() == this.dimension ? context.getWorld() : null) : (world = context.getWorld().func_73046_m().func_71218_a(this.dimension)));
        if (world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile == null) {
            return null;
        }
        try {
            return (T)tile;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

