/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;

public abstract class BaseScreen
extends Screen {
    private final List<Widget> widgets = new LinkedList<Widget>();
    private final List<ITickableWidget> tickableWidgets = new LinkedList<ITickableWidget>();

    protected BaseScreen(ITextComponent title) {
        super(title);
    }

    protected abstract float sizeX();

    protected abstract float sizeY();

    protected float left() {
        return ((float)this.field_230708_k_ - this.sizeX()) / 2.0f;
    }

    protected float top() {
        return ((float)this.field_230709_l_ - this.sizeY()) / 2.0f;
    }

    protected void func_231160_c_() {
        this.widgets.clear();
        this.tickableWidgets.clear();
        this.addWidgets();
    }

    protected abstract void addWidgets();

    protected <T extends Widget> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.add((ITickableWidget)((Object)widget));
        }
        return widget;
    }

    protected <T extends Widget> T removeWidget(T widget) {
        this.widgets.remove(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.remove(widget);
        }
        return widget;
    }

    public void func_231023_e_() {
        this.tickableWidgets.forEach(ITickableWidget::tick);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        matrixStack.func_227861_a_((double)this.left(), (double)this.top(), 0.0);
        mouseX = (int)((float)mouseX - this.left());
        mouseY = (int)((float)mouseY - this.top());
        matrixStack.func_227860_a_();
        this.render(matrixStack, mouseX, mouseY);
        matrixStack.func_227865_b_();
        for (Widget widget : this.widgets) {
            widget.blitOffset = this.func_230927_p_();
            widget.wasHovered = widget.hovered;
            widget.hovered = mouseX > widget.x && mouseX < widget.x + widget.width && mouseY > widget.y && mouseY < widget.y + widget.height;
            widget.render(matrixStack, mouseX, mouseY, partialTicks);
            widget.narrate();
        }
        for (Widget widget : this.widgets) {
            ITextComponent text;
            if (!(widget instanceof IHoverTextWidget) || !widget.isHovered() || (text = ((IHoverTextWidget)((Object)widget)).getHoverText()) == null) continue;
            this.func_238652_a_(matrixStack, text, mouseX, mouseY);
        }
        this.renderTooltips(matrixStack, mouseX, mouseY);
    }

    protected abstract void render(MatrixStack var1, int var2, int var3);

    protected void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    protected void drawScreenBackground(MatrixStack matrixStack, float x, float y, float width, float height) {
        ScreenUtils.drawScreenBackground(matrixStack, x, y, width, height);
    }

    protected void drawScreenBackground(MatrixStack matrixStack) {
        ScreenUtils.drawScreenBackground(matrixStack, 0.0f, 0.0f, this.sizeX(), this.sizeY());
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.onMousePress((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.onMouseRelease((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseReleased((int)mouseX, (int)mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        this.onMouseScroll((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), delta);
        for (Widget widget : this.widgets) {
            widget.mouseScrolled((int)mouseX, (int)mouseY, delta);
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.keyPressed(keyCode)) {
            return true;
        }
        InputMappings.Input key = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(key)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean keyPressed(int keyCode) {
        boolean handled = false;
        for (Widget widget : this.widgets) {
            if (widget instanceof TextFieldWidget && ((TextFieldWidget)widget).canWrite()) {
                handled = true;
            }
            widget.keyPressed(keyCode);
        }
        return handled;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased(keyCode);
    }

    public boolean keyReleased(int keyCode) {
        for (Widget widget : this.widgets) {
            widget.keyReleased(keyCode);
        }
        return false;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.charTyped(codePoint);
    }

    public boolean charTyped(char c) {
        for (Widget widget : this.widgets) {
            widget.charTyped(c);
        }
        return false;
    }
}

