/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AbstractSmokeParticle {

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Instance
    extends SpriteTexturedParticle {
        private static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
        private static final double ON_HIT_MOTION_REDICTION = 0.7;
        protected boolean inChimney = false;
        protected int ticksInChimney = 0;
        protected final IWind wind;
        protected final IAnimatedSprite animatedSprite;
        private int hitAfterHitCount = 0;

        public Instance(ClientWorld world, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, IAnimatedSprite sprite) {
            super(world, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            this.animatedSprite = sprite;
            this.wind = wind;
            this.func_217566_b(sprite);
            this.field_190017_n = (Boolean)Smoke.canCollide.get();
            ++GameWorld.getData((IWorld)world).smokeParticlesCount;
        }

        public abstract void updateAnimatedSprite();

        public void func_187112_i() {
            --GameWorld.getData((IWorld)this.field_187122_b).smokeParticlesCount;
            super.func_187112_i();
        }

        public Vect3d getPosition() {
            return Vect3d.from((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h);
        }

        public Vect3d getMotion() {
            return Vect3d.from((double)this.field_187129_i, (double)this.field_187130_j, (double)this.field_187131_k);
        }

        public void setMotion(Vect3d motion) {
            this.field_187129_i = motion.x;
            this.field_187130_j = motion.y;
            this.field_187131_k = motion.z;
        }

        public void setColor(ColorARGB color) {
            this.func_70538_b(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public void setPosition(Vect3d pos) {
            this.func_187109_b(pos.x, pos.y, pos.z);
        }

        public BlockPos getBlockPos() {
            return new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        }

        protected void tryColorizeWith(ColorARGB color) {
            if (Smoke.colorize == null || !((Boolean)Smoke.colorize.get()).booleanValue()) {
                return;
            }
            float alpha = color.getAlpha().toFloat();
            if (CommonMath.Random.result((float)(alpha * ((Double)Smoke.coloringFactor.get()).floatValue()))) {
                this.setColor(color);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void func_189213_a() {
            IWind wind;
            block7: {
                this.field_187122_b.func_217381_Z().func_76320_a("smokeParticle.update");
                ++this.field_70546_d;
                if (this.field_70546_d >= this.field_70547_e) {
                    this.func_187112_i();
                }
                this.field_187123_c = this.field_187126_f;
                this.field_187124_d = this.field_187127_g;
                this.field_187125_e = this.field_187128_h;
                BlockPos blockPos = this.getBlockPos();
                BlockState state = this.field_187122_b.func_180495_p(blockPos);
                Block block = state.func_177230_c();
                boolean inSolidBlock = true;
                for (Direction face : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
                    if (state.func_224755_d((IBlockReader)this.field_187122_b, blockPos, face)) continue;
                    inSolidBlock = false;
                    break;
                }
                boolean canSeeSky = false;
                if (!inSolidBlock) {
                    for (BlockPos pos : GameWorld.Positions.getAroundHoriz((BlockPos)blockPos, (boolean)true, (BlockPos[])new BlockPos[0])) {
                        if (!this.field_187122_b.func_226660_f_(pos)) continue;
                        canSeeSky = true;
                        break;
                    }
                }
                Object object = wind = !inSolidBlock || canSeeSky ? this.wind : Wind.NONE;
                if (block instanceof ISmokeContainer) {
                    ISmokeContainer container = (ISmokeContainer)block;
                    if (container.isChimney() && CommonMath.notZero((double)this.field_187130_j) && this.field_187130_j > 0.0) {
                        this.inChimney = true;
                        ColorARGB color = container.getColor();
                        this.tryColorizeWith(color);
                        ++this.ticksInChimney;
                        --this.field_70546_d;
                        break block7;
                    } else {
                        this.func_187112_i();
                        this.field_187122_b.func_217381_Z().func_76319_b();
                        return;
                    }
                }
                this.inChimney = false;
            }
            this.updateAnimatedSprite();
            this.field_187130_j -= (double)this.field_70545_g;
            Vect3d motion = this.getMotion().add(wind.getMotion());
            this.move(motion);
            this.field_187122_b.func_217381_Z().func_76319_b();
        }

        public void func_187110_a(double dx, double dy, double dz) {
            this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
        }

        public void move(Vect3d motion) {
            Vect3d nextPos = this.getPosition().add(motion);
            this.moveTo(nextPos);
        }

        private void moveTo(Vect3d nextPos) {
            if (this.field_190017_n) {
                if (this.hitAfterHitCount > 2) {
                    this.func_187112_i();
                    return;
                }
                Vect3d curPos = this.getPosition();
                BlockPos blockPos = nextPos.toBlockPos();
                BlockState blockState = this.field_187122_b.func_180495_p(blockPos);
                BlockRayTraceResult hit = blockState.func_196952_d((IBlockReader)this.field_187122_b, blockPos).func_212433_a(curPos.toVector3d(), nextPos.toVector3d(), blockPos);
                if (hit != null && hit.func_216346_c() != RayTraceResult.Type.MISS) {
                    ++this.hitAfterHitCount;
                    Direction.Axis axis = hit.func_216354_b().func_176740_k();
                    Vect3d hitLocation = Vect3d.from((Vector3d)hit.func_216347_e());
                    Vect3d bounceVec = nextPos.subtract(hitLocation);
                    switch (axis) {
                        case X: {
                            bounceVec = bounceVec.invertX();
                            this.field_187129_i = -this.field_187129_i;
                            break;
                        }
                        case Z: {
                            bounceVec = bounceVec.invertZ();
                            this.field_187131_k = -this.field_187131_k;
                            break;
                        }
                        case Y: {
                            bounceVec = bounceVec.invertY();
                            CommonMath.Angle angle = CommonMath.Angle.random();
                            double motion = this.field_187130_j * this.getOnHitMotionReduction();
                            motion = Math.max(motion, 0.1);
                            this.field_187129_i = angle.cos() * motion;
                            this.field_187131_k = angle.sin() * motion;
                            this.field_187130_j = 0.0;
                            this.field_190017_n = false;
                            this.field_187132_l = true;
                            break;
                        }
                        default: {
                            this.func_187112_i();
                            return;
                        }
                    }
                    nextPos = hitLocation.add(bounceVec);
                    this.moveTo(nextPos);
                    return;
                }
            }
            this.hitAfterHitCount = 0;
            this.setPosition(nextPos);
        }

        protected double getOnHitMotionReduction() {
            return 0.7;
        }

        public abstract IParticleRenderType func_217558_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Factory<T extends IParticleData>
    implements IParticleFactory<T> {
        protected final IAnimatedSprite sprite;

        public Factory(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public abstract Particle func_199234_a(T var1, ClientWorld var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }

    public static abstract class Deserializer<T extends IParticleData>
    implements IParticleData.IDeserializer<T> {
    }

    public static abstract class Data
    implements IParticleData {
        public final IWind wind;
        public final Smoke smoke;

        public Data(IWind wind, Smoke smoke) {
            this.wind = wind;
            this.smoke = smoke;
        }

        public void func_197553_a(PacketBuffer buffer) {
        }

        public String func_197555_a() {
            return Registry.field_212632_u.func_177774_c((Object)this.func_197554_b()).toString();
        }
    }
}

