/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.event;

import info.u_team.useful_backpacks.api.IBackpack;
import info.u_team.useful_backpacks.config.CommonConfig;
import info.u_team.useful_backpacks.item.BackpackItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemPickupEventHandler {
    public static final List<Function<ServerPlayerEntity, ItemStack>> INTEGRATION_BACKPACKS = new ArrayList<Function<ServerPlayerEntity, ItemStack>>();

    private static void onEntityItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ItemStack stackToPickup = event.getItem().func_92059_d();
        if (stackToPickup.func_77973_b() instanceof BackpackItem && !((Boolean)CommonConfig.getInstance().allowStackingBackpacks.get()).booleanValue()) {
            return;
        }
        ItemStack resultStack = ItemPickupEventHandler.insertInBackpacks((ServerPlayerEntity)player, stackToPickup);
        stackToPickup.func_190920_e(resultStack.func_190916_E());
        if (resultStack.func_190926_b()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private static ItemStack insertInBackpacks(ServerPlayerEntity player, ItemStack stackToPickup) {
        PlayerInventory playerInventory = player.field_71071_by;
        for (Function<ServerPlayerEntity, ItemStack> function : INTEGRATION_BACKPACKS) {
            ItemStack stack = function.apply(player);
            if (stack.func_190926_b() || !(stackToPickup = ItemPickupEventHandler.insertInBackpack(player, stack, stackToPickup)).func_190926_b()) continue;
            return stackToPickup;
        }
        for (int index = 0; index < playerInventory.func_70302_i_(); ++index) {
            ItemStack stack = playerInventory.func_70301_a(index);
            stackToPickup = ItemPickupEventHandler.insertInBackpack(player, stack, stackToPickup);
            if (!stackToPickup.func_190926_b()) continue;
            return stackToPickup;
        }
        return stackToPickup;
    }

    private static ItemStack insertInBackpack(ServerPlayerEntity player, ItemStack stack, ItemStack stackToPickup) {
        IBackpack backpack;
        Item item = stack.func_77973_b();
        if (item instanceof IBackpack && (backpack = (IBackpack)item).canAutoPickup(stackToPickup, stack)) {
            IInventory inventory = backpack.getInventory(player, stack);
            InvWrapper itemHandler = new InvWrapper(inventory);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stackToPickup, (boolean)false);
            if (result.func_190916_E() != stackToPickup.func_190916_E()) {
                backpack.saveInventory(inventory, stack);
            }
            stackToPickup = result;
        }
        return stackToPickup;
    }

    public static void registerForge(IEventBus bus) {
        bus.addListener(EventPriority.HIGHEST, ItemPickupEventHandler::onEntityItemPickup);
    }
}

