/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import org.apache.commons.lang3.tuple.Pair;

public class Style
implements ILostCityAsset {
    private String name;
    private final List<List<Pair<Float, String>>> randomPaletteChoices = new ArrayList<List<Pair<Float, String>>>();

    public Style(String name) {
        this.name = name;
    }

    public Style(JsonObject object) {
        this.readFromJSon(object);
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        JsonArray array = object.get("randompalettes").getAsJsonArray();
        for (JsonElement element : array) {
            ArrayList<Pair> palettes = new ArrayList<Pair>();
            for (JsonElement el : element.getAsJsonArray()) {
                float factor = el.getAsJsonObject().get("factor").getAsFloat();
                String style = el.getAsJsonObject().get("palette").getAsString();
                palettes.add(Pair.of((Object)Float.valueOf(factor), (Object)style));
            }
            this.randomPaletteChoices.add(palettes);
        }
    }

    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("style"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        JsonArray array = new JsonArray();
        for (List<Pair<Float, String>> list : this.randomPaletteChoices) {
            JsonArray a = new JsonArray();
            for (Pair<Float, String> pair : list) {
                JsonObject o = new JsonObject();
                o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
                o.add("palette", (JsonElement)new JsonPrimitive((String)pair.getValue()));
                a.add((JsonElement)o);
            }
            array.add((JsonElement)a);
        }
        object.add("randompalettes", (JsonElement)array);
        return object;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Palette getRandomPalette(IDimensionInfo provider, Random random) {
        Palette palette = new Palette();
        for (List<Pair<Float, String>> pairs : this.randomPaletteChoices) {
            float totalweight = 0.0f;
            for (Pair<Float, String> pair : pairs) {
                totalweight += ((Float)pair.getKey()).floatValue();
            }
            float r = random.nextFloat() * totalweight;
            Palette tomerge = null;
            for (Pair<Float, String> pair : pairs) {
                if (!((r -= ((Float)pair.getKey()).floatValue()) <= 0.0f)) continue;
                tomerge = AssetRegistries.PALETTES.get((String)pair.getRight());
                if (tomerge != null) break;
                throw new RuntimeException("Palette '" + (String)pair.getRight() + "' is missing!");
            }
            palette.merge(tomerge);
        }
        return palette;
    }
}

