/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.ILostCityAssetRegistry;
import mcjty.lostcities.api.ILostCityBuilding;
import mcjty.lostcities.api.ILostCityCityStyle;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostcities.api.ILostCityMultiBuilding;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;

public class LostCitiesImp
implements ILostCities {
    private final Map<RegistryKey<World>, LostCityInformation> info = new HashMap<RegistryKey<World>, LostCityInformation>();

    @Override
    @Nullable
    public ILostCityInformation getLostInfo(World world) {
        IDimensionInfo dimensionInfo = Registration.LOSTCITY_FEATURE.getDimensionInfo((ISeedReader)world);
        if (dimensionInfo != null) {
            if (!this.info.containsKey(world.func_234923_W_())) {
                LostCityInformation gen = new LostCityInformation(dimensionInfo);
                this.info.put((RegistryKey<World>)world.func_234923_W_(), gen);
            }
            return this.info.get(world.func_234923_W_());
        }
        return null;
    }

    public static class LostCityInformation
    implements ILostCityInformation {
        private final IDimensionInfo dimensionInfo;

        public LostCityInformation(IDimensionInfo dimensionInfo) {
            this.dimensionInfo = dimensionInfo;
        }

        @Override
        public ILostChunkInfo getChunkInfo(int chunkX, int chunkZ) {
            return BuildingInfo.getBuildingInfo(chunkX, chunkZ, this.dimensionInfo);
        }

        @Override
        public int getRealHeight(int level) {
            return this.dimensionInfo.getProfile().GROUNDLEVEL + level * 6;
        }

        @Override
        public ILostCityAssetRegistry<ILostCityBuilding> getBuildings() {
            return AssetRegistries.BUILDINGS.cast();
        }

        @Override
        public ILostCityAssetRegistry<ILostCityMultiBuilding> getMultiBuildings() {
            return AssetRegistries.MULTI_BUILDINGS.cast();
        }

        @Override
        public ILostCityAssetRegistry<ILostCityCityStyle> getCityStyles() {
            return AssetRegistries.CITYSTYLES.cast();
        }
    }
}

