/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterTile;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SettingUpdatePacket {
    private TypeEnums.SETTING setting;

    public SettingUpdatePacket(TypeEnums.SETTING setting) {
        this.setting = setting;
    }

    private SettingUpdatePacket() {
    }

    static SettingUpdatePacket decode(PacketBuffer buffer) {
        SettingUpdatePacket packet = new SettingUpdatePacket();
        packet.setting = TypeEnums.SETTING.values()[buffer.readInt()];
        return packet;
    }

    static void handle(SettingUpdatePacket packet, Supplier<? extends NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        context.get().enqueueWork(() -> SettingUpdatePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(SettingUpdatePacket packet, @Nullable ServerPlayerEntity player) {
        if (player != null && player.field_71070_bA instanceof MeterContainer) {
            MeterTile tile = ((MeterContainer)player.field_71070_bA).getTile();
            World level = tile.func_145831_w();
            if (level == null || !level.func_195588_v(tile.func_174877_v())) {
                return;
            }
            tile.updateSetting(packet.setting);
            tile.func_70296_d();
        }
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.setting.ordinal());
    }
}

